/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.filetransfer;

import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.platform.PlatformFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousFileTransfer<R extends FileTransferRequest> {
    private static final Logger log = Logger.getLogger(SynchronousFileTransfer.class);
    FileTransferService<R> ftService;
    String topicName;

    public SynchronousFileTransfer(FileTransferService<R> ftService, String topicName) {
        this.ftService = ftService;
        this.topicName = topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTransferEvent executeTransfer(R request, long timeout) {
        long sessionId = this.ftService.createSession();
        FileTransferServiceListener listener = new FileTransferServiceListener(sessionId);
        PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener(this.topicName, listener);
        FileTransferServiceListener fileTransferServiceListener = listener;
        synchronized (fileTransferServiceListener) {
            this.ftService.addRequest(sessionId, request);
            this.ftService.startSession(sessionId);
            this.ftService.closeSession(sessionId);
            try {
                listener.wait(timeout);
            }
            catch (InterruptedException ex) {
                log.debug((Object)"", (Throwable)ex);
            }
        }
        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(listener);
        return listener.getEvent();
    }

    private class FileTransferServiceListener
    implements MessageListener {
        private FileTransferEvent event;
        private long sessionId;

        public FileTransferServiceListener(long sessionId) {
            this.sessionId = sessionId;
        }

        public synchronized void onMessage(Message msg) {
            try {
                int eventType;
                FileTransferEvent event = (FileTransferEvent)((ObjectMessage)msg).getObject();
                if (event.getSessionId() == this.sessionId && ((eventType = event.getEventType()) == 3 || eventType == 2)) {
                    this.event = event;
                    this.notify();
                }
            }
            catch (JMSException e) {
                log.debug((Object)"", (Throwable)e);
            }
        }

        public FileTransferEvent getEvent() {
            return this.event;
        }
    }
}

