/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.filesystem;

import com.bwanms.mediation.FileSystemService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileSystemFileOutputStream
extends OutputStream {
    private FileSystemService fss;
    private String fileName;
    private long fileHandle;

    public FileSystemFileOutputStream(FileSystemService fss, String fileName) throws IOException, FileNotFoundException {
        this.fss = fss;
        this.fileName = fileName;
        this.fileHandle = fss.openFile(fileName, 1);
    }

    public void close() throws IOException {
        this.fss.closeFile(this.fileHandle);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] copy = new byte[len];
        System.arraycopy(b, off, copy, 0, len);
        this.fss.write(this.fileHandle, copy);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes);
    }
}

