/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.filesystem;

import com.bwanms.mediation.FileSystemService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemFileInputStream
extends InputStream {
    private FileSystemService fss;
    private String fileName;
    private long fileHandle;

    public FileSystemFileInputStream(FileSystemService fss, String fileName) throws IOException, FileNotFoundException {
        this.fss = fss;
        this.fileName = fileName;
        this.fileHandle = fss.openFile(fileName, 0);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        byte[] ret = this.fss.read(this.fileHandle, len);
        System.arraycopy(ret, 0, b, off, ret.length);
        return ret.length == 0 ? -1 : ret.length;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b = this.fss.read(this.fileHandle, 1);
        if (b.length == 0) {
            return -1;
        }
        return b[0];
    }

    public void close() throws IOException {
        this.fss.closeFile(this.fileHandle);
    }
}

