/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.ejb;

import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.NetworkScanSession;
import com.bwanms.mediation.ejb.NetworkScanMediationServiceMBean;
import com.bwanms.mediation.impl.NetworkScanMediationServiceImpl;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ejb.MBeanProxyFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.system.ServiceMBeanSupport;

public class NetworkScanMediationService
extends ServiceMBeanSupport
implements NetworkScanMediationServiceMBean {
    private NetworkScanSession delegate;

    public void startService() throws Exception {
        this.delegate = new NetworkScanMediationServiceImpl();
        this.rebind();
        this.log.info((Object)"----------------- STARTED SERVICE NETWORK_SCAN_SESSION");
    }

    public void stopService() throws Exception {
        this.unbind();
    }

    private void rebind() throws NamingException {
        PlatformFactory.getMediationLayerPlatform(null).getLookup().bind("bwanms/mediation/NetworkScanSession", MBeanProxyFactory.createProxy(NetworkScanSession.class, this.getServiceName()));
    }

    private void unbind() {
        try {
            InitialContext rootCtx = new InitialContext();
            rootCtx.unbind("topic/NetworkScanMediationTopic");
        }
        catch (NamingException e) {
            this.log.error((Object)e);
        }
    }

    public long createSession() {
        return this.delegate.createSession();
    }

    public void addRequest(long sessionId, NetworkScanMediationRequest request) {
        this.delegate.addRequest(sessionId, request);
    }

    public void closeSession(long sessionId) {
        this.delegate.closeSession(sessionId);
    }

    public void abortSession(long sessionId) {
        this.delegate.abortSession(sessionId);
    }

    public boolean isSessionRunning(long sessionId) {
        return this.delegate.isSessionRunning(sessionId);
    }

    public void startSession(long sessionId) {
        this.delegate.startSession(sessionId);
    }
}

