/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.ejb;

import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.NetworkScanSession;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.ejb.EJBServiceProxy;
import com.bwanms.mediation.ejb.MediationAgentBrokerService;
import com.bwanms.mediation.ejb.NetworkScanSessionEJB;
import com.bwanms.mediation.ejb.NetworkScanSessionEJBHome;
import com.bwanms.mediation.ejb.TftpFileTransferServiceEJB;
import com.bwanms.mediation.ejb.TftpFileTransferServiceEJBHome;
import com.bwanms.mediation.impl.MOAccessSessionImpl;
import com.bwanms.mediation.impl.MediationAgentBroker;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.platform.PlatformFactory;
import org.apache.log4j.Logger;

public class MediationServiceRegistryEJBImpl
extends MediationServiceRegistry {
    private Logger logger = Logger.getLogger(MediationServiceRegistryEJBImpl.class);
    private MediationAgentBroker brokerInstance;

    protected MOAccessSession getMOSessionInstance(SNMPManagementInterface mi, NetworkResourceHandler nrHandler) throws MediationException {
        return new MOAccessSessionImpl(mi, nrHandler);
    }

    private MediationAgentBroker broker() {
        if (this.brokerInstance == null) {
            try {
                this.brokerInstance = MediationAgentBrokerService.findMediationAgentBroker();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.brokerInstance;
    }

    private void handleException(Throwable t) {
        this.logger.error((Object)t);
        t.printStackTrace();
    }

    private Object lookup(String partition, String name) throws Exception {
        return PlatformFactory.getMediationLayerPlatform(partition).getLookup().lookup(name);
    }

    protected NetworkScanSession getNetworkScanMediationServiceInstance() {
        try {
            NetworkScanSessionEJB ejbRef = ((NetworkScanSessionEJBHome)this.lookup("", "bwanms/mediation/networkscansession")).create();
            return (NetworkScanSession)EJBServiceProxy.create("", ejbRef, NetworkScanSession.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    protected TftpFileTransferService getTftpFileTransferServiceInstance() {
        try {
            TftpFileTransferServiceEJB ejbRef = ((TftpFileTransferServiceEJBHome)this.lookup("", "bwanms/mediation/tftpservice")).create();
            return (TftpFileTransferService)EJBServiceProxy.create("", ejbRef, TftpFileTransferService.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    protected FileSystemService getFileSystemServiceInstance() {
        return (FileSystemService)PlatformFactory.getMediationLayerPlatform(null).getLookup().lookup("bwanms/mediation/FileSystem");
    }
}

