/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.ejb;

import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.ejb.DiskFileSystemServiceMBean;
import com.bwanms.mediation.impl.DiskFileSystemServiceImpl;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ejb.MBeanProxyFactory;
import com.bwanms.util.Settings;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.system.ServiceMBeanSupport;

public class DiskFileSystemService
extends ServiceMBeanSupport
implements DiskFileSystemServiceMBean {
    private String rootDirectory = Settings.instance().getApplicationDir() + "/filesystem";
    private DiskFileSystemServiceImpl delegate;

    public void startService() {
        this.delegate = new DiskFileSystemServiceImpl();
        this.delegate.setRootDirectory(this.rootDirectory);
        this.delegate.start();
        PlatformFactory.getMediationLayerPlatform(null).getLookup().bind("bwanms/mediation/FileSystem", MBeanProxyFactory.createProxy(FileSystemService.class, this.getServiceName()));
    }

    public void stopService() {
        PlatformFactory.getMediationLayerPlatform(null).getLookup().unbind("bwanms/mediation/FileSystem");
        this.delegate.stop();
        this.delegate = null;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void deleteFile(String fileName) throws IOException {
        this.delegate.deleteFile(fileName);
    }

    public long openFile(String fileName, int mode) throws FileNotFoundException, IOException {
        return this.delegate.openFile(fileName, mode);
    }

    public void closeFile(long fileHandle) throws IOException {
        this.delegate.closeFile(fileHandle);
    }

    public void write(long fileHandle, byte[] data) throws IOException {
        this.delegate.write(fileHandle, data);
    }

    public byte[] read(long fileHandle, int maxLength) throws IOException {
        return this.delegate.read(fileHandle, maxLength);
    }

    public String getTemporaryFileName(String prefix, String suffix) {
        return this.delegate.getTemporaryFileName(prefix, suffix);
    }

    public void createFolder(String folderName) throws IOException {
        this.delegate.createFolder(folderName);
    }

    public void deleteFolder(String folderName, boolean cascade) throws IOException {
        this.delegate.deleteFolder(folderName, cascade);
    }

    public String[] listFiles(String folderName) throws IOException {
        return this.delegate.listFiles(folderName);
    }

    public String[] listSubFolders(String folderName) throws IOException {
        return this.delegate.listSubFolders(folderName);
    }

    public long length(long fileHandle) throws IOException {
        return this.delegate.length(fileHandle);
    }
}

