/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation;

import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.NetworkScanSession;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.util.PlatformConfiguration;

public abstract class MediationServiceRegistry {
    private static MediationServiceRegistry instance;

    public static MOAccessSession getMOSession(SNMPManagementInterface agentInfo, NetworkResourceHandler nrHandler) throws MediationException {
        return MediationServiceRegistry.instance().getMOSessionInstance(agentInfo, nrHandler);
    }

    public static NetworkScanSession getNetworkScanMediationService() {
        return MediationServiceRegistry.instance().getNetworkScanMediationServiceInstance();
    }

    public static TftpFileTransferService getTftpFileTransferService() {
        return MediationServiceRegistry.instance().getTftpFileTransferServiceInstance();
    }

    public static FileSystemService getFileSystemService() {
        return MediationServiceRegistry.instance().getFileSystemServiceInstance();
    }

    public static final MediationServiceRegistry instance() {
        if (instance == null) {
            try {
                instance = (MediationServiceRegistry)PlatformConfiguration.instance().getMediationServiceRegistryImpl().newInstance();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return instance;
    }

    protected abstract MOAccessSession getMOSessionInstance(SNMPManagementInterface var1, NetworkResourceHandler var2) throws MediationException;

    protected abstract NetworkScanSession getNetworkScanMediationServiceInstance();

    protected abstract TftpFileTransferService getTftpFileTransferServiceInstance();

    protected abstract FileSystemService getFileSystemServiceInstance();
}

