/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation;

import java.io.Serializable;

public abstract class FileTransferRequest
implements Serializable {
    public static final int OPERATION_PUT = 0;
    public static final int OPERATION_GET = 1;
    private String localFile;
    private String remoteFile;
    private int operation;
    private Serializable userData;
    private byte[] fileData;

    public FileTransferRequest(String localFile, String remoteFile, int operation, Serializable userData) {
        this.localFile = localFile;
        this.remoteFile = remoteFile;
        this.operation = operation;
        this.userData = userData;
    }

    public FileTransferRequest(byte[] fileData, String remoteFile, Serializable userData) {
        this(null, remoteFile, 0, userData);
        this.fileData = fileData;
    }

    public FileTransferRequest(String remoteFile, Serializable userData) {
        this(null, remoteFile, 1, userData);
    }

    public String getLocalFile() {
        return this.localFile;
    }

    public String getRemoteFile() {
        return this.remoteFile;
    }

    public int getOperation() {
        return this.operation;
    }

    public Serializable getUserData() {
        return this.userData;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public abstract String getSynchronizationKey();

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }
}

