/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation;

import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.MediationException;
import java.io.Serializable;

public final class FileTransferEvent
implements Serializable {
    public static final int EVENT_TYPE_REQUEST_STARTED = 0;
    public static final int EVENT_TYPE_REQUEST_PROGRESS = 1;
    public static final int EVENT_TYPE_REQUEST_ERROR = 2;
    public static final int EVENT_TYPE_REQUEST_COMPLETED = 3;
    public static final int EVENT_TYPE_SESSION_FINISHED = 10;
    private Serializable userData;
    private long sessionId;
    private int eventType;
    private long progress;
    private byte[] fileData;
    private MediationException error;

    public static FileTransferEvent requestStarted(long sessionId, FileTransferRequest request) {
        FileTransferEvent event = new FileTransferEvent();
        event.sessionId = sessionId;
        event.userData = request.getUserData();
        event.eventType = 0;
        return event;
    }

    public static FileTransferEvent requestProgress(long sessionId, FileTransferRequest request, long progress) {
        FileTransferEvent event = new FileTransferEvent();
        event.sessionId = sessionId;
        event.userData = request.getUserData();
        event.progress = progress;
        event.eventType = 1;
        return event;
    }

    public static FileTransferEvent requestError(long sessionId, FileTransferRequest request, MediationException error) {
        FileTransferEvent event = new FileTransferEvent();
        event.sessionId = sessionId;
        event.userData = request.getUserData();
        event.error = error;
        event.eventType = 2;
        return event;
    }

    public static FileTransferEvent requestCompleted(long sessionId, FileTransferRequest request) {
        FileTransferEvent event = new FileTransferEvent();
        event.sessionId = sessionId;
        event.userData = request.getUserData();
        event.fileData = request.getOperation() == 1 ? request.getFileData() : null;
        event.eventType = 3;
        return event;
    }

    public static FileTransferEvent sessionCompleted(long sessionId) {
        FileTransferEvent event = new FileTransferEvent();
        event.sessionId = sessionId;
        event.eventType = 10;
        return event;
    }

    private FileTransferEvent() {
    }

    public long getProgress() {
        return this.progress;
    }

    public int getEventType() {
        return this.eventType;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Serializable getUserData() {
        return this.userData;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public MediationException getError() {
        return this.error;
    }
}

