/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.maintenance;

import com.bwanms.maintenance.IConfiguration;
import com.bwanms.maintenance.ServerMaintenanceMain;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    private static final Logger LOG = Logger.getLogger(Configuration.class);
    private static Pattern validationPattern = Pattern.compile("-a([1-3]){1,3}");
    private static Pattern extractionPattern = Pattern.compile("[1-3]");
    private Strategy strategy;
    private Context context;
    public static final Configuration INSTANCE = new Configuration();
    private String host;
    private List<Character> inputs;

    private Configuration() {
    }

    public boolean checkArgs(String[] args) {
        boolean ret = true;
        if (args.length == 0) {
            this.strategy = Strategy.INPUT;
        } else if (args.length == 1 && this.isValidInput(args[0])) {
            this.fillInputs(args[0]);
            this.strategy = Strategy.INPUTNESS;
        } else {
            ret = false;
        }
        return ret;
    }

    private void fillInputs(String input) {
        Matcher matcher = extractionPattern.matcher(input);
        this.inputs = new ArrayList<Character>();
        while (matcher.find()) {
            String group = matcher.group();
            if (group.length() != 1) {
                throw new IllegalStateException("Extraction pattern for this configuration is invalid.");
            }
            this.inputs.add(Character.valueOf(group.charAt(0)));
        }
        LOG.debug((Object)this.getInputs().toString());
    }

    private boolean isValidInput(String input) {
        return validationPattern.matcher(input).matches();
    }

    @Override
    public void configure(Serializable ctx) throws ConfigurationException {
        try {
            if (!(ctx instanceof String[])) {
                throw new ConfigurationException(new IllegalArgumentException("The context is invalid. It must be a String array."));
            }
            this.host = System.getProperty("bwanms.as.host");
            String port = System.getProperty("bwanms.as.port");
            if (this.host == null || port == null) {
                URL resource = ServerMaintenanceMain.class.getResource("/jboss_connection.properties");
                Properties props = new Properties();
                props.load(resource.openStream());
                this.host = props.getProperty("bwanms.as.host");
                port = props.getProperty("bwanms.as.port");
            }
            String providerUrl = this.host + ':' + port;
            Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
            jndiProperties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            jndiProperties.put("java.naming.provider.url", providerUrl);
            this.context = new InitialContext(jndiProperties);
            LOG.debug((Object)"Initial context was get.");
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new ConfigurationException(ex);
        }
        catch (NamingException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new ConfigurationException(ex);
        }
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    protected Context getContext() {
        return this.context;
    }

    public List<Character> getInputs() {
        return this.inputs;
    }

    protected String getHost() {
        return this.host;
    }

    protected static class ConfigurationException
    extends Exception {
        public ConfigurationException() {
        }

        public ConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }

        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Strategy {
        INPUTNESS,
        INPUT;

    }
}

