/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.maintenance;

import com.bwanms.LogCodeProvider;
import com.bwanms.maintenance.Configuration;
import com.bwanms.maintenance.IProvider;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public abstract class AbstractProvider
implements IProvider {
    private static final Logger LOG = Logger.getLogger(AbstractProvider.class);
    private static final String SERVER_UNREACHABLE = "ASTR-100: AlvariSTAR  server %s is either down or unreachable.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void provide() {
        try {
            Character input;
            this.redirectMessages();
            while ((input = this.getInput()) != null) {
                if (this.isValid(input)) {
                    this.getInfo(input.charValue());
                    continue;
                }
                this.warn(input);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                Context ctx = Configuration.INSTANCE.getContext();
                if (ctx != null) {
                    ctx.close();
                    LOG.debug((Object)"Initial context was closed");
                }
            }
            catch (NamingException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void warn(Character input) {
        if (input.charValue() != '\r' && input.charValue() != '\n') {
            LogCodeProvider.redirectLogForCode(System.out, "Invalid option");
        }
    }

    private boolean isValid(Character input) {
        return input.charValue() == '1' || input.charValue() == '2' || input.charValue() == '3';
    }

    private void getInfo(int ch) {
        try {
            Object lookup = Configuration.INSTANCE.getContext().lookup("jmx/invoker/RMIAdaptor");
            RMIAdaptor rmiAdaptor = (RMIAdaptor)PortableRemoteObject.narrow((Object)lookup, RMIAdaptor.class);
            if (rmiAdaptor != null && rmiAdaptor.isRegistered(new ObjectName("bwanms.server.maintenance:service=ServerMaintenance"))) {
                ObjectName objectName = new ObjectName("bwanms.server.maintenance:service=ServerMaintenance");
                switch (ch) {
                    case 49: {
                        Boolean serverUp = (Boolean)rmiAdaptor.getAttribute(objectName, "ServerUp");
                        if (serverUp.booleanValue()) {
                            LogCodeProvider.redirectLogForCode(System.out, "ASTR-000: AlvariSTAR  server %s is up.", Configuration.INSTANCE.getHost());
                            break;
                        }
                        LogCodeProvider.redirectLogForCode(System.out, SERVER_UNREACHABLE, Configuration.INSTANCE.getHost());
                        break;
                    }
                    case 50: {
                        long uptime = Calendar.getInstance().getTimeInMillis() - ((Calendar)rmiAdaptor.getAttribute(objectName, "StartTime")).getTimeInMillis();
                        LogCodeProvider.redirectLogForCode(System.out, "Uptime: %d", uptime);
                        break;
                    }
                    case 51: {
                        long maxMemory = (Long)rmiAdaptor.getAttribute(objectName, "JVMMaxMemory");
                        long totalMemory = (Long)rmiAdaptor.getAttribute(objectName, "JVMTotalMemory");
                        long freeMemory = (Long)rmiAdaptor.getAttribute(objectName, "JVMFreeMemory");
                        LogCodeProvider.redirectLogForCode(System.out, "Memory usage: \n\t%d used\n\t%d max\n\t%d commited", totalMemory - freeMemory, maxMemory, totalMemory);
                        break;
                    }
                    default: {
                        LogCodeProvider.redirectLogForCode(System.out, "Unknown command");
                    }
                }
            }
        }
        catch (NamingException ex) {
            LogCodeProvider.redirectLogForCode(System.out, SERVER_UNREACHABLE, Configuration.INSTANCE.getHost());
        }
        catch (MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
        catch (AttributeNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (MBeanException ex) {
            ex.printStackTrace();
        }
        catch (ReflectionException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract Character getInput() throws IOException;

    private boolean isInputness() {
        return Configuration.INSTANCE.getStrategy() == Configuration.Strategy.INPUTNESS;
    }

    protected abstract void redirectMessages();
}

