/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.maintenance;

import com.bwanms.LogCodeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ASAlreadyStartedCheckMain {
    public static final String OWARE_USER_ROOT = "OWARE_USER_ROOT";
    public static final String FILE_SEPARATOR = File.separator;
    private static final String owareUserRoot = System.getenv("OWARE_USER_ROOT");
    private static final String INSTALLED_PROP_PATH = owareUserRoot + FILE_SEPARATOR + "owareapps" + FILE_SEPARATOR + "installprops" + FILE_SEPARATOR + "lib" + FILE_SEPARATOR + "installed.properties";
    private static final String OWAPPSERVER_PROP_PATH = owareUserRoot + FILE_SEPARATOR + "oware" + FILE_SEPARATOR + "lib" + FILE_SEPARATOR + "owappserver.properties";
    private static final int DB_CONNECTION_FAILURE = 1;
    private static final int SERVER_ALREADY_STARTED = 2;

    public static void main(String[] args) {
        boolean up = ASAlreadyStartedCheckMain.checkDb();
        boolean started = ASAlreadyStartedCheckMain.checkAS();
        if (!up) {
            System.out.println("[Application server startup] Startup failed - AlvariSTAR Database ASTR_DB is either down or unreachable.");
            System.exit(1);
        }
        if (started) {
            LogCodeProvider.redirectLogForCode(System.out, "ASTR-300");
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDb() {
        boolean up = false;
        System.out.printf("Path to installed.properties: %s%n", INSTALLED_PROP_PATH);
        Properties installedProp = new Properties();
        Connection con = null;
        try {
            installedProp.load(new FileInputStream(INSTALLED_PROP_PATH));
            String rdbms = installedProp.getProperty("com.dorado.bom_dbms.name");
            String dbDriver = null;
            String dbURL = null;
            String dbUser = null;
            String dbPassword = null;
            if ("mysql".equals(rdbms)) {
                dbDriver = "com.mysql.jdbc.Driver";
                dbURL = "jdbc:mysql:" + installedProp.getProperty("com.dorado.jdbc.database_name.mysql");
                dbUser = "oware";
                dbPassword = "dorado";
            } else if ("oracle".equals(rdbms)) {
                dbDriver = "oracle.jdbc.driver.OracleDriver";
                dbURL = "jdbc:oracle:thin:" + installedProp.getProperty("com.dorado.jdbc.database_name.oracle");
                dbUser = installedProp.getProperty("com.dorado.jdbc.user");
                dbPassword = installedProp.getProperty("com.dorado.jdbc.password");
            } else {
                String msg = "Unknown/unsupported rdbms.";
                System.err.println(msg);
            }
            Class.forName(dbDriver);
            con = DriverManager.getConnection(dbURL, dbUser, dbPassword);
            up = true;
            System.out.println("Database connection succeded");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return up;
    }

    private static boolean checkAS() {
        boolean started = false;
        try {
            Properties installedProp = new Properties();
            installedProp.load(new FileInputStream(INSTALLED_PROP_PATH));
            String host = installedProp.getProperty("oware.local.ip.address");
            Properties owappserverProp = new Properties();
            owappserverProp.load(new FileInputStream(OWAPPSERVER_PROP_PATH));
            String jnpPort = owappserverProp.getProperty("oware.listenPort.appserver");
            Socket socket = new Socket(InetAddress.getByName(host), Integer.parseInt(jnpPort));
            if (socket.isConnected()) {
                System.out.println("AS already started");
                started = true;
            } else {
                System.out.printf("Failed to connect to %s on port %s", host, jnpPort);
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return started;
    }
}

