/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeShrinkAppender
extends RollingFileAppender {
    private static final Logger log = Logger.getLogger(SizeShrinkAppender.class);
    protected static final int DEFAULT_RETAIN_DAYS = 10;
    protected static final String DEFAULT_MAX_FILES_SIZE = "2GB";
    private static final int THREADS_NO = 1;
    private static final long DEFAULT_TIMEOUT = 60L;
    private static final long DEFAULT_INTERVAL = 60000L;
    protected int retainsDays;
    protected String maxFilesSize;
    protected long scheduleInterval = 60000L;
    private ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Log Shrinking Thread");
            thread.setDaemon(true);
            return thread;
        }
    });
    private long millisec = System.currentTimeMillis();

    public SizeShrinkAppender() {
        this.name = SizeShrinkAppender.class.getSimpleName();
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        if (this.timeIntervalExcedeed(this.millisec, this.getScheduleInterval())) {
            this.executor.submit(new Runnable(){

                public void run() {
                    SizeShrinkAppender.this.exec(SizeShrinkAppender.this.fileName, SizeShrinkAppender.this.qw);
                }
            });
        }
    }

    private boolean timeIntervalExcedeed(long millisec2, long millisecInterval) {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - millisec2 >= millisecInterval) {
            this.setMillisec(currentTimeMillis);
            return true;
        }
        return false;
    }

    void exec(String fn, QuietWriter quietWriter) {
        int retainsDays2 = this.getRetainsDays();
        String maxFilesSize2 = this.getMaxFilesSize();
        log.debug((Object)"********************************************");
        log.debug((Object)"Starting files log size shrink operation ...");
        log.debug((Object)String.format("[Application Log Aging] Retains days = %d.%n", retainsDays2));
        log.debug((Object)String.format("[Application Log Aging] Max files size = %s.%n", maxFilesSize2));
        if (fn != null && quietWriter != null) {
            final String fileExtension = this.getFileExtension(fn);
            File file = new File(fn);
            File absFile = new File(file.getAbsolutePath());
            final File dir = absFile.getParentFile();
            File[] files = dir.listFiles(new FilenameFilter(){

                public boolean accept(File d, String name) {
                    return d.equals(dir) && name.contains(fileExtension);
                }
            });
            ArrayList<File> filesLst = new ArrayList<File>();
            Collections.addAll(filesLst, files);
            Collections.sort(filesLst, new FileComparator());
            this.deleteOlderFilesThan(filesLst, retainsDays2);
            if (!this.isFilesSizeLesserThan(filesLst, this.getSize(maxFilesSize2))) {
                this.deleteFilesToReduceTotalSizeTo(filesLst, this.getSize(maxFilesSize2));
            }
        }
        log.debug((Object)"Finished files log size shrink operation ...");
        log.debug((Object)"********************************************");
    }

    private String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46));
    }

    private void deleteFilesToReduceTotalSizeTo(List<File> filesLst, long maxFilesSize2) {
        log.debug((Object)String.format("[Application Log Aging] [Old Log Files Delete Policy] Max log files size trigger was fired.", new Object[0]));
        boolean deletingSuccess = true;
        boolean conditionFulfilled = false;
        while (this.getFilesSize(filesLst) > maxFilesSize2) {
            conditionFulfilled = true;
            File file = filesLst.get(0);
            if (!file.delete()) {
                deletingSuccess = false;
                log.debug((Object)String.format("[Application Log Aging] [Total Log Files Size Delete Policy] %s file wasn't deleted.%n", file.getName()));
            } else {
                log.debug((Object)String.format("[Application Log Aging] [Total Log Files Size Delete Policy] %s file was deleted.%n", file.getName()));
            }
            filesLst.remove(0);
        }
        if (conditionFulfilled) {
            this.logResult(deletingSuccess);
        }
    }

    private void deleteOlderFilesThan(List<File> files, int retainsDays) {
        log.debug((Object)String.format("[Application Log Aging] [Old Log Files Delete Policy] Older log files deletion policy was fired.", new Object[0]));
        Calendar iniTime = Calendar.getInstance();
        iniTime.add(6, -retainsDays);
        boolean deletingSuccess = true;
        boolean conditionFulfilled = false;
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (!file.isFile() || file.lastModified() >= iniTime.getTimeInMillis()) continue;
            conditionFulfilled = true;
            if (!file.delete()) {
                deletingSuccess = false;
                log.debug((Object)String.format("[Application Log Aging] [Old Log Files Delete Policy] %s file wasn't deleted.%n", file.getName()));
            } else {
                log.debug((Object)String.format("[Application Log Aging] [Old Log Files Delete Policy] %s file was deleted.%n", file.getName()));
            }
            files.remove(i);
            --i;
        }
        if (conditionFulfilled) {
            this.logResult(deletingSuccess);
        }
    }

    private void logResult(boolean deletingSuccess) {
        if (deletingSuccess) {
            log.info((Object)"[Application Log Aging] Old AlvariSTAR application logs were deleted.");
        } else {
            log.warn((Object)"[Application Log Aging] Unable to delete old AlvariSTAR application logs.");
        }
    }

    private boolean isFilesSizeLesserThan(List<File> files, long maxFileSize) {
        long filesSize = this.getFilesSize(files);
        log.debug((Object)String.format("[Application Log Aging] Total log files size = %d, Max File Size = %d", filesSize, maxFileSize));
        return filesSize <= maxFileSize;
    }

    private long getFilesSize(List<File> files) {
        long size = 0L;
        for (File file : files) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    public int getRetainsDays() {
        if (this.retainsDays != 0 && this.retainsDays != 10) {
            return this.retainsDays;
        }
        this.retainsDays = Integer.getInteger("com.bwanms.logging.retainsDays") == null ? 10 : Integer.getInteger("com.bwanms.logging.retainsDays");
        return this.retainsDays;
    }

    public String getMaxFilesSize() {
        if (this.maxFilesSize == null && this.maxFilesSize.equals(DEFAULT_MAX_FILES_SIZE)) {
            return this.maxFilesSize;
        }
        this.maxFilesSize = System.getProperty("com.bwanms.logging.maxFilesSize") == null ? DEFAULT_MAX_FILES_SIZE : System.getProperty("com.bwanms.logging.maxFilesSize");
        return this.maxFilesSize;
    }

    protected long getSize(String size) {
        String cantity = size.substring(0, size.length() - 2);
        String um = size.substring(size.length() - 2);
        if ("MB".equalsIgnoreCase(um)) {
            return Long.parseLong(cantity) * 1024L * 1024L;
        }
        if ("GB".equalsIgnoreCase(um)) {
            return Long.parseLong(cantity) * 1024L * 1024L * 1024L;
        }
        if ("KB".equalsIgnoreCase(um)) {
            return Long.parseLong(cantity) * 1024L;
        }
        return Long.parseLong(size);
    }

    public void finalize() {
        System.out.println("Finalize invocation");
        this.close();
    }

    public synchronized void close() {
        super.close();
        this.executor.shutdown();
        try {
            if (!this.executor.isTerminated() && !this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                System.err.println("Timeout excedeed for gracefully executor termination. It was abruptly shutdown");
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public long getMillisec() {
        return this.millisec;
    }

    public void setMillisec(long millisec) {
        this.millisec = millisec;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public long getScheduleInterval() {
        return this.scheduleInterval;
    }

    public void setScheduleInterval(long scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public void setRetainsDays(int retainsDays) {
        this.retainsDays = retainsDays;
    }

    public void setMaxFilesSize(String maxFilesSize) {
        this.maxFilesSize = maxFilesSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return new Date(file1.lastModified()).compareTo(new Date(file2.lastModified()));
        }
    }
}

