/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.visualization.jgraph;

import com.bwanms.gui.visualization.jgraph.EntityView;
import com.bwanms.gui.visualization.jgraph.ObjectDetails;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class ObjectDetailsRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient EntityView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient boolean isDoubleBuffered = false;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = Color.black;
    protected transient Color highlightColor = Color.black;
    protected transient Color lockedHandleColor = Color.black;
    protected transient Image icon = Toolkit.getDefaultToolkit().getImage(ObjectDetailsRenderer.class.getResource("container_obj.gif"));
    protected transient Font font = new Font("Arial", 0, 8);
    private Object entity;
    private Dimension preferredSize;
    private static final Color[] SEVERITY_COLORS = new Color[]{Color.WHITE, Color.GREEN, Color.BLUE, Color.YELLOW, Color.ORANGE, Color.RED};
    private Font textFont = new Font("Arial", 0, 10);
    private Font boldFont = new Font("Arial", 1, 12);
    private static int INSET = 4;

    public ObjectDetailsRenderer() {
        this.defaultForeground = UIManager.getColor("Tree.textForeground");
        this.defaultBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.gridColor = graph.getGridColor();
        this.highlightColor = graph.getHighlightColor();
        this.lockedHandleColor = graph.getLockedHandleColor();
        this.isDoubleBuffered = graph.isDoubleBuffered();
        if (view instanceof EntityView) {
            this.view = (EntityView)view;
            this.setComponentOrientation(graph.getComponentOrientation());
            if (graph.getEditingCell() != view.getCell()) {
                DefaultGraphCell cell = (DefaultGraphCell)view.getCell();
                this.entity = cell.getUserObject();
            }
            this.hasFocus = focus;
            this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
            this.selected = sel;
            this.preview = preview;
            if (this.view.isLeaf() || GraphConstants.isGroupOpaque((Map)view.getAllAttributes())) {
                this.installAttributes(view);
            } else {
                this.resetAttributes();
            }
            return this;
        }
        return null;
    }

    protected void resetAttributes() {
        this.setBorder(null);
        this.setOpaque(false);
        this.setGradientColor(null);
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        AttributeMap map = view.getAllAttributes();
        this.setOpaque(GraphConstants.isOpaque((Map)map));
        this.setBorder(GraphConstants.getBorder((Map)map));
        this.bordercolor = GraphConstants.getBorderColor((Map)map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = GraphConstants.getForeground((Map)map)) != null ? foreground : this.defaultForeground);
        Color gradientColor = GraphConstants.getGradientColor((Map)map);
        this.setGradientColor(gradientColor);
        Color background = GraphConstants.getBackground((Map)map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(GraphConstants.getFont((Map)map));
    }

    public Dimension getPreferredSize() {
        return this.computeCellSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public Dimension computeCellSize() {
        Graphics g = this.getGraphics();
        ObjectDetails objectDetails = (ObjectDetails)this.entity;
        String[][] details = objectDetails.getObjectDetails();
        FontMetrics metrics = g.getFontMetrics(this.textFont);
        FontMetrics boldMetrics = g.getFontMetrics(this.boldFont);
        int maxKey = 0;
        int maxVal = 0;
        for (int i = 0; i < details.length; ++i) {
            int valWidth;
            int keyWidth = (int)boldMetrics.getStringBounds(details[i][0], g).getWidth();
            if (keyWidth > maxKey) {
                maxKey = keyWidth;
            }
            if (details[i][1] == null || (valWidth = (int)metrics.getStringBounds(details[i][1], g).getWidth()) <= maxVal) continue;
            maxVal = valWidth;
        }
        int textHeight = metrics.getHeight();
        int rWidth = maxKey + maxVal + 2 * INSET;
        int rHeight = textHeight * details.length + 2 * INSET;
        return new Dimension(rWidth, rHeight);
    }

    public void paint(Graphics g) {
        super.paint(g);
        ObjectDetails objectDetails = (ObjectDetails)this.entity;
        String[][] details = objectDetails.getObjectDetails();
        FontMetrics metrics = g.getFontMetrics(this.textFont);
        FontMetrics boldMetrics = g.getFontMetrics(this.boldFont);
        int maxKey = 0;
        int maxVal = 0;
        for (int i = 0; i < details.length; ++i) {
            int valWidth;
            int keyWidth = (int)boldMetrics.getStringBounds(details[i][0], g).getWidth();
            if (keyWidth > maxKey) {
                maxKey = keyWidth;
            }
            if (details[i][1] == null || (valWidth = (int)metrics.getStringBounds(details[i][1], g).getWidth()) <= maxVal) continue;
            maxVal = valWidth;
        }
        int textHeight = metrics.getHeight();
        int textAscent = metrics.getAscent();
        int rWidth = maxKey + maxVal + 2 * INSET;
        int rHeight = textHeight * details.length + 2 * INSET;
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(0, 0, rWidth, rHeight);
        g.setColor(new Color(1.0f, 1.0f, 0.0f, 0.7f));
        g.fillRoundRect(0, 0, rWidth - 1, rHeight - 1, 20, 20);
        g.setColor(Color.LIGHT_GRAY);
        g.drawRoundRect(0, 0, rWidth - 1, rHeight - 1, 20, 20);
        g.setColor(Color.BLACK);
        int[] columnStart = new int[]{0, maxKey};
        if (details != null) {
            for (int i = 0; i < details.length; ++i) {
                for (int j = 0; j < 2; ++j) {
                    g.setFont(j == 0 ? this.boldFont : this.textFont);
                    String text = details[i][j] == null || "".equals(details[i][j]) ? "-" : details[i][j];
                    g.drawString(text, columnStart[j] + INSET, INSET + i * textHeight + textAscent);
                }
            }
        }
        g.setClip(clipBounds);
    }

    protected void paintSelectionBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        g2.setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected || this.selected) {
            if (this.childrenSelected) {
                g.setColor(this.gridColor);
            } else if (this.hasFocus && this.selected) {
                g.setColor(this.lockedHandleColor);
            } else if (this.selected) {
                g.setColor(this.highlightColor);
            }
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
        g2.setStroke(previousStroke);
    }

    public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double beta = pi2 - alpha;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter - width * Math.tan(alpha) / 2.0;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter - height * Math.tan(beta) / 2.0;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter + width * Math.tan(alpha) / 2.0;
        } else {
            yout = y + height;
            xout = xCenter + height * Math.tan(beta) / 2.0;
        }
        return new Point2D.Double(xout, yout);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }
}

