/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.visualization.jgraph;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.topology.Node;
import java.util.ArrayList;

public class ObjectDetails {
    private static Internationalizer ddiI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static Internationalizer i18n = Internationalizer.getInternationalizer(ObjectDetails.class);
    private Object target;

    public void setTarget(Object target) {
        this.target = target;
    }

    public String[][] getObjectDetails() {
        int i;
        if (this.target == null) {
            return new String[0][2];
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        if (this.target instanceof Node) {
            Node node = (Node)this.target;
            keys.add(i18n.translateString("Name"));
            values.add(node.getName() == null ? "" : node.getName());
            keys.add(i18n.translateString("Type"));
            values.add(ddiI18n.translateString(node.getObjectID().getClassName()));
            String[][] targetDetails = node.getDetails();
            for (i = 0; i < targetDetails.length; ++i) {
                keys.add(targetDetails[i][0]);
                values.add(targetDetails[i][1]);
            }
        } else {
            return new String[0][2];
        }
        String[][] ret = new String[keys.size()][2];
        for (i = 0; i < ret.length; ++i) {
            ret[i][0] = (String)keys.get(i);
            ret[i][1] = (String)values.get(i);
        }
        return ret;
    }
}

