/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.visualization.jgraph;

import com.bwanms.gui.visualization.jgraph.EntityViewFactory;
import com.bwanms.gui.visualization.jgraph.ObjectDetails;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.Link;
import com.bwanms.model.topology.LinkID;
import com.bwanms.model.topology.Node;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class JGraphTopologyVisualizationAdapter {
    private static final Logger log = Logger.getLogger(JGraphTopologyVisualizationAdapter.class);
    private JGraph jGraph;
    private HashMap<ObjectID, DefaultGraphCell> endPointMap = new HashMap();
    private HashMap<ObjectID, Port> portMap = new HashMap();
    private HashMap<LinkID, DefaultEdge> linkMap = new HashMap();
    private ObjectDetails details = new ObjectDetails();
    private DefaultGraphCell objectDetailsCell = new DefaultGraphCell((Object)this.details);

    public JGraphTopologyVisualizationAdapter(JGraph jGraph) {
        this.jGraph = jGraph;
        jGraph.getSelectionModel().setSelectionMode(4);
        this.initialize();
        this.jGraph.getGraphLayoutCache().setFactory((CellViewFactory)new EntityViewFactory());
    }

    private void initialize() {
        GraphModel model = this.jGraph.getModel();
        while (model.getRootCount() > 0) {
            model.remove(new Object[]{model.getRootAt(0)});
        }
    }

    private void initializeObjectDetails(int x, int y, int w, int h) {
        GraphConstants.setBounds((Map)this.objectDetailsCell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, w, h));
        GraphConstants.setSizeable((Map)this.objectDetailsCell.getAttributes(), (boolean)true);
        GraphConstants.setEditable((Map)this.objectDetailsCell.getAttributes(), (boolean)false);
        GraphConstants.setSelectable((Map)this.objectDetailsCell.getAttributes(), (boolean)false);
        this.jGraph.getGraphLayoutCache().insert((Object)this.objectDetailsCell);
    }

    public void initializeObjectDetails(int x, int y, int w, int h, Object target) {
        this.initializeObjectDetails(x, y, w, h);
        this.setLegend(target);
    }

    public void addLinkEndPoint(Node linkEndPoint, double x, double y, double w, double h) {
        DefaultGraphCell cell = new DefaultGraphCell((Object)linkEndPoint);
        GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, w, h));
        GraphConstants.setSizeable((Map)cell.getAttributes(), (boolean)false);
        GraphConstants.setEditable((Map)cell.getAttributes(), (boolean)false);
        cell.addPort();
        Port port = (Port)cell.getChildren().iterator().next();
        this.portMap.put(linkEndPoint.getObjectID(), port);
        this.endPointMap.put(linkEndPoint.getObjectID(), cell);
        this.jGraph.getGraphLayoutCache().insert((Object)cell);
        if (log.isDebugEnabled()) {
            this.debugMemUsage();
        }
    }

    public void linkEndPointChanged(Node linkEndPoint) {
        this.jGraph.getGraphLayoutCache().valueForCellChanged((Object)this.endPointMap.get(linkEndPoint.getObjectID()), (Object)linkEndPoint);
        if (log.isDebugEnabled()) {
            this.debugMemUsage();
        }
    }

    public void removeLinkEndPoint(Node linkEndPoint) {
        ObjectID oid = linkEndPoint.getObjectID();
        this.jGraph.getGraphLayoutCache().remove(new Object[]{this.portMap.get(oid), this.endPointMap.get(oid)});
        this.endPointMap.remove(oid);
        this.portMap.remove(oid);
    }

    public Node[] getSelectedItems() {
        Object[] selectedCells = this.jGraph.getSelectionCells();
        ArrayList<Node> retList = new ArrayList<Node>();
        for (int i = 0; i < selectedCells.length; ++i) {
            if (!(selectedCells[i] instanceof DefaultGraphCell)) continue;
            retList.add((Node)((DefaultGraphCell)selectedCells[i]).getUserObject());
        }
        Node[] ret = new Node[retList.size()];
        return retList.toArray(ret);
    }

    public Rectangle2D getLinkEndPointBounds(ObjectID linkEndPointId) {
        DefaultGraphCell cell = this.endPointMap.get(linkEndPointId);
        if (cell != null) {
            Rectangle2D bounds = GraphConstants.getBounds((Map)cell.getAttributes());
            return new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        }
        return null;
    }

    public void updateLink(Link link) {
        LinkID linkId = link.getLinkId();
        DefaultEdge edge = this.linkMap.get(linkId);
        if (edge == null) {
            DefaultGraphCell aCell = this.endPointMap.get(link.getAEndPoint());
            DefaultGraphCell zCell = this.endPointMap.get(link.getZEndPoint());
            if (aCell != null && zCell != null) {
                edge = new DefaultEdge((Object)link);
                GraphConstants.setEditable((Map)edge.getAttributes(), (boolean)false);
                GraphConstants.setDisconnectable((Map)edge.getAttributes(), (boolean)false);
                Node aNode = (Node)aCell.getUserObject();
                Node zNode = (Node)zCell.getUserObject();
                if (aNode.getState() != 0 || zNode.getState() != 0) {
                    GraphConstants.setDashPattern((Map)edge.getAttributes(), (float[])new float[]{10.0f, 10.0f});
                }
                edge.setSource((Object)aCell.getChildAt(0));
                edge.setTarget((Object)zCell.getChildAt(0));
                this.linkMap.put(link.getLinkId(), edge);
                this.jGraph.getGraphLayoutCache().insert((Object)edge);
                this.jGraph.getGraphLayoutCache().toFront(new Object[]{aCell, zCell});
                log.debug((Object)("Link added [" + linkId + "]"));
            } else {
                log.debug((Object)("Link not added [" + linkId + "]"));
            }
        } else {
            edge.setUserObject((Object)link);
            this.jGraph.getGraphLayoutCache().valueForCellChanged((Object)edge, (Object)link);
            log.debug((Object)("Link updated [" + linkId + "]"));
        }
    }

    public void removeLink(LinkID linkId) {
        DefaultEdge edge = this.linkMap.remove(linkId);
        if (edge != null) {
            this.jGraph.getGraphLayoutCache().remove(new Object[]{edge});
        }
    }

    public boolean containsLink(LinkID linkID) {
        return this.linkMap.containsKey(linkID);
    }

    public boolean containsEndPoint(ObjectID endPointId) {
        return this.endPointMap.containsKey(endPointId);
    }

    public Node getEndPoint(Object graphCell) {
        return graphCell == null ? null : (Node)((DefaultGraphCell)graphCell).getUserObject();
    }

    public Node getSelectedEndPoint() {
        Object cell = this.jGraph.getSelectionCell();
        return this.isLinkEndPointCell(cell) ? this.getEndPoint(cell) : null;
    }

    public boolean isLinkEndPointCell(Object cell) {
        return cell != null && ((DefaultGraphCell)cell).getUserObject() instanceof Node;
    }

    public void setLegend(Object target) {
        ((ObjectDetails)this.objectDetailsCell.getUserObject()).setTarget(target);
        this.jGraph.getGraphLayoutCache().valueForCellChanged((Object)this.objectDetailsCell, this.objectDetailsCell.getUserObject());
    }

    public Node isLinkEndPointCellAt(double x, double y) {
        for (DefaultGraphCell cell : this.endPointMap.values()) {
            Rectangle2D bounds;
            if (!this.isLinkEndPointCell(cell) || !(bounds = GraphConstants.getBounds((Map)cell.getAttributes())).contains(x, y)) continue;
            return this.getEndPoint(cell);
        }
        return null;
    }

    public void hideLegend() {
        this.jGraph.getGraphLayoutCache().remove(new Object[]{this.objectDetailsCell});
    }

    public void clearTopology() {
        this.jGraph.getGraphLayoutCache().remove(this.portMap.values().toArray());
        this.portMap.clear();
        this.jGraph.getGraphLayoutCache().remove(this.endPointMap.values().toArray());
        this.endPointMap.clear();
        this.jGraph.getGraphLayoutCache().remove(this.linkMap.values().toArray());
        this.linkMap.clear();
    }

    private void debugMemUsage() {
        log.info((Object)("endPointMap: " + this.endPointMap.size()));
        log.info((Object)("linkMap    : " + this.linkMap.size()));
        log.info((Object)("jgraph cell views: " + this.jGraph.getGraphLayoutCache().getCellViews().length));
        log.info((Object)("jgraph ports     : " + this.jGraph.getGraphLayoutCache().getPorts().length));
    }
}

