/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.visualization.jgraph;

import com.bwanms.gui.util.EquipmentUIIconFactory;
import com.bwanms.gui.visualization.jgraph.EntityView;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.topology.Node;
import com.bwanms.util.fault.EventUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class EquipmentRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient EntityView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient boolean isDoubleBuffered = false;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = Color.black;
    protected transient Color highlightColor = Color.black;
    protected transient Color lockedHandleColor = Color.black;
    protected transient Image icon = Toolkit.getDefaultToolkit().getImage(EquipmentRenderer.class.getResource("container_obj.gif"));
    protected transient Font font = new Font("Arial", 0, 8);
    private Object entity;
    private Dimension preferredSize;
    private ImageIcon unreachableOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("error_co.gif"));

    public EquipmentRenderer() {
        this.defaultForeground = UIManager.getColor("Tree.textForeground");
        this.defaultBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.gridColor = graph.getGridColor();
        this.highlightColor = graph.getHighlightColor();
        this.lockedHandleColor = graph.getLockedHandleColor();
        this.isDoubleBuffered = graph.isDoubleBuffered();
        if (view instanceof EntityView) {
            this.view = (EntityView)view;
            this.setComponentOrientation(graph.getComponentOrientation());
            if (graph.getEditingCell() != view.getCell()) {
                DefaultGraphCell cell = (DefaultGraphCell)view.getCell();
                this.entity = cell.getUserObject();
            }
            this.hasFocus = focus;
            this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
            this.selected = sel;
            this.preview = preview;
            if (this.view.isLeaf() || GraphConstants.isGroupOpaque((Map)view.getAllAttributes())) {
                this.installAttributes(view);
            } else {
                this.resetAttributes();
            }
            return this;
        }
        return null;
    }

    protected void resetAttributes() {
        this.setBorder(null);
        this.setOpaque(false);
        this.setGradientColor(null);
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        AttributeMap map = view.getAllAttributes();
        this.setOpaque(GraphConstants.isOpaque((Map)map));
        this.setBorder(GraphConstants.getBorder((Map)map));
        this.bordercolor = GraphConstants.getBorderColor((Map)map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = GraphConstants.getForeground((Map)map)) != null ? foreground : this.defaultForeground);
        Color gradientColor = GraphConstants.getGradientColor((Map)map);
        this.setGradientColor(gradientColor);
        Color background = GraphConstants.getBackground((Map)map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(GraphConstants.getFont((Map)map));
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension d = this.getSize();
        Node vertex = (Node)this.entity;
        Color clr = null;
        clr = vertex.getState() != 0 ? (vertex.getState() == -5 || vertex.getState() == -3 ? Color.WHITE : (vertex.getState() == -1 ? new Color(255, 100, 100) : EventUtil.getSeverityColor(Severity.Critical))) : EventUtil.getSeverityColor(Severity.fromValue(Math.max(vertex.getAlarmState(), Severity.Cleared.value())));
        g.setColor(clr);
        g.fillRect(0, 0, d.width - 1, 20);
        g.setColor(Color.WHITE);
        g.fillRect(0, 21, d.width - 1, d.height - 21);
        if (this.view.getIcon() != null) {
            this.view.getIcon().paintIcon(this, g, (d.width - 16) / 2, 4);
        }
        g.setColor(Color.BLACK);
        g.setFont(this.font);
        String name = vertex.getName();
        if (name == null) {
            name = "";
        }
        g.drawString(name, 2, 29);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        g.drawLine(0, 20, d.width - 1, 20);
        this.paintSelectionBorder(g);
        if (vertex.getState() == -1) {
            Graphics2D g2d = (Graphics2D)g;
            Composite originalComposite = g2d.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2d.setComposite(alpha);
            g2d.setComposite(originalComposite);
            g2d.drawImage(this.unreachableOverlay.getImage(), (d.width - 16) / 2 + this.view.getIcon().getIconWidth() - this.unreachableOverlay.getIconWidth(), 4 + this.view.getIcon().getIconHeight() - this.unreachableOverlay.getIconHeight(), this);
        }
    }

    protected void paintSelectionBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        g2.setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected || this.selected) {
            if (this.childrenSelected) {
                g.setColor(this.gridColor);
            } else if (this.hasFocus && this.selected) {
                g.setColor(this.lockedHandleColor);
            } else if (this.selected) {
                g.setColor(this.highlightColor);
            }
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
        g2.setStroke(previousStroke);
    }

    public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double beta = pi2 - alpha;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter - width * Math.tan(alpha) / 2.0;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter - height * Math.tan(beta) / 2.0;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter + width * Math.tan(alpha) / 2.0;
        } else {
            yout = y + height;
            xout = xCenter + height * Math.tan(beta) / 2.0;
        }
        return new Point2D.Double(xout, yout);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }
}

