/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.util;

import com.bwanms.client.gui.fault.ColorSchema;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.model.Service;
import com.bwanms.model.fault.constants.Severity;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceUIIconFactory
extends UIIconFactory {
    private static final Color[] SEVERITY_COLORS = new Color[]{ColorSchema.getActiveSchema().cleared(), ColorSchema.getActiveSchema().indeterminate(), ColorSchema.getActiveSchema().warning(), ColorSchema.getActiveSchema().minor(), ColorSchema.getActiveSchema().major(), ColorSchema.getActiveSchema().critical()};

    public abstract ImageIcon getPlainIcon(Class<? extends Service> var1);

    @Override
    public final Icon getIconImpl(Object target, int flags) {
        return new ServiceIcon(this.getPlainIcon(((Service)target).getClass()), (Service)target, flags);
    }

    @Override
    public Icon getIconForClassImpl(Class clazz) {
        return this.getPlainIcon(clazz);
    }

    private class ServiceIcon
    implements Icon {
        private ImageIcon delegate;
        private Service service;
        private int flags;

        public ServiceIcon(ImageIcon delegate, Service service, int flags) {
            this.delegate = delegate;
            this.service = service;
            this.flags = flags;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            if ((this.flags & 2) != 0) {
                switch (this.service.getState()) {
                    case 1: {
                        g.setColor(SEVERITY_COLORS[this.service.getAlarmState()]);
                        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                        break;
                    }
                    case -2: {
                        g.setColor(SEVERITY_COLORS[Severity.Critical.value() - 1]);
                        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                        break;
                    }
                    default: {
                        grayed = true;
                    }
                }
            }
            if (grayed |= (this.flags & 1) != 0) {
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.drawImage(this.delegate.getImage(), x, y, c);
                g2d.setComposite(originalComposite);
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }
    }
}

