/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.util;

import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.util.fault.EventUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EquipmentUIIconFactory
extends UIIconFactory {
    private ImageIcon unreachableOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("error_co.gif"));
    private ImageIcon unlicensedOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("warning_co.gif"));
    private static final String platformType = System.getProperty("com.bwanms.platform", "remote");

    public abstract ImageIcon getPlainIcon(Class<? extends Equipment> var1);

    @Override
    public final Icon getIconImpl(Object target, int flags) {
        return new EquipmentIcon(this.getPlainIcon(((Equipment)target).getClass()), (Equipment)target, flags);
    }

    @Override
    public Icon getIconForClassImpl(Class clazz) {
        return this.getPlainIcon(clazz);
    }

    private class EquipmentIcon
    implements Icon {
        private ImageIcon delegate;
        private Equipment equipment;
        private int flags;

        public EquipmentIcon(ImageIcon delegate, Equipment equipment, int flags) {
            this.delegate = delegate;
            this.equipment = equipment;
            this.flags = flags;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            boolean licensed = LicenseClient.getInstance().isLicensed(this.equipment);
            if ((this.flags & 2) != 0) {
                if (platformType.equalsIgnoreCase("local")) {
                    if (licensed && this.equipment.getState() == 0) {
                        g.setColor(EventUtil.getSeverityColor(Severity.Cleared));
                        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                    } else if (licensed && this.equipment.getState() == 1) {
                        g.setColor(EventUtil.getSeverityColor(Severity.Critical));
                        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                    } else {
                        grayed = true;
                    }
                } else if (licensed && (this.equipment.getState() == 0 || this.equipment.getState() == 1)) {
                    if (this.equipment.getState() == 1) {
                        g.setColor(EventUtil.getSeverityColor(Severity.Critical));
                    } else {
                        g.setColor(EventUtil.getSeverityColor(Severity.fromValue(Math.max(this.equipment.getAlarmState(), Severity.Cleared.value()))));
                    }
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                } else {
                    grayed = true;
                }
            }
            if (grayed |= (this.flags & 1) != 0) {
                if (licensed && this.equipment.getState() != -3) {
                    g.setColor(EventUtil.getSeverityColor(Severity.Critical));
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                }
                g.drawImage(this.delegate.getImage(), x, y, c);
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.setComposite(originalComposite);
                if (licensed) {
                    g2d.drawImage(EquipmentUIIconFactory.this.unreachableOverlay.getImage(), x + this.getIconWidth() - EquipmentUIIconFactory.this.unreachableOverlay.getIconWidth(), y + this.getIconHeight() - EquipmentUIIconFactory.this.unreachableOverlay.getIconHeight(), c);
                } else {
                    g2d.drawImage(EquipmentUIIconFactory.this.unlicensedOverlay.getImage(), x + this.getIconWidth() - EquipmentUIIconFactory.this.unlicensedOverlay.getIconWidth(), y + this.getIconHeight() - EquipmentUIIconFactory.this.unreachableOverlay.getIconHeight(), c);
                }
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }
    }
}

