/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.util;

import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel {
    private ArrayList<TreeModelListener> listeners = new ArrayList();

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        Object[] path = e.getPath();
        Object source = e.getSource();
        for (TreeModelListener l : this.listeners) {
            l.treeNodesChanged(e);
        }
        if (path.length > 1) {
            Object[] subPath = new Object[path.length - 1];
            System.arraycopy(path, 0, subPath, 0, subPath.length);
            this.fireTreeNodesChanged(new TreeModelEvent(source, subPath));
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener l : this.listeners) {
            l.treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener l : this.listeners) {
            l.treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(e);
        }
    }
}

