/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager.xsl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public abstract class XSLTransformer {
    public static final String ENCODING = "UTF8";
    private static final Logger log = Logger.getLogger(XSLTransformer.class);
    private String content;
    private TransformerFactory tFactory = TransformerFactory.newInstance();
    private Transformer transformer;

    public abstract URL getXSLInputStream();

    public String transform() {
        String processedContent = null;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            URL xslURL = this.getXSLInputStream();
            log.debug((Object)("URL: " + xslURL));
            this.transformer = this.tFactory.newTransformer(new StreamSource(xslURL.openConnection().getInputStream(), xslURL.toString()));
            processedContent = this.processContent(this.content);
            StreamSource src = new StreamSource(new ByteArrayInputStream(processedContent.getBytes(ENCODING)));
            StreamResult result = new StreamResult(outStream);
            this.transformer.transform(src, result);
            String retVal = outStream.toString();
            outStream.close();
            return retVal;
        }
        catch (Exception e) {
            if (processedContent != null) {
                log.error((Object)("Cannot transform content: " + processedContent));
            }
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String processContent(String content) throws IOException {
        return content;
    }

    public String getFileExtension() {
        return "html";
    }
}

