/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager.xsl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.NetworkScanTask;
import com.bwanms.model.SNMPAgentAuthentication;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static String beginReport(String title, Date date) {
        StringBuffer header = new StringBuffer();
        header.append("<?xml version=\"1.0\"?>");
        header.append("<report>");
        header.append("<header>");
        header.append("<title>").append(title).append("</title>");
        header.append("<date>").append(date.toString()).append("</date>");
        header.append("</header>");
        header.append("<data>");
        return header.toString();
    }

    public static String addRow(String ip, AgentAuthentication auth, String response) {
        StringBuffer header = new StringBuffer();
        SNMPAgentAuthentication snmp_auth = (SNMPAgentAuthentication)auth;
        header.append("<row>");
        header.append("<ip>").append(ip).append("</ip>");
        if (auth != null) {
            header.append("<read-community>").append(snmp_auth.getReadCommunity()).append("</read-community>");
            header.append("<write-community>").append(snmp_auth.getWriteCommunity()).append("</write-community>");
        } else {
            header.append("<read-community>").append("</read-community>");
            header.append("<write-community>").append("</write-community>");
        }
        header.append("<response>").append(response).append("</response>");
        header.append("</row>");
        return header.toString();
    }

    public static String endReport() {
        StringBuffer header = new StringBuffer();
        header.append("</data>");
        header.append("</report>");
        return header.toString();
    }

    public static String createReportForNetworkTask(String title, Map<Integer, NetworkIpAddressRange> ranges, Map<Integer, IPScanResult[]> results, NetworkScanTask task) {
        Internationalizer ipresulti18n = Internationalizer.getInternationalizer(IPScanResult.class);
        int totalScanned = 0;
        int discovered = 0;
        StringBuffer report = new StringBuffer();
        report.append(XMLUtil.beginReport(title, new Date()));
        for (int i : ranges.keySet()) {
            report.append(XMLUtil.startRange(ranges.get(i)));
            totalScanned += results.get(i).length;
            for (IPScanResult result : results.get(i)) {
                if (result == null) continue;
                String resultString = null;
                if (result.getOID() != null) {
                    resultString = ipresulti18n.translateString(result.getResultString(), result.getEqName(), result.getOID());
                    ++discovered;
                } else {
                    resultString = ipresulti18n.translateString(result.getResultString());
                }
                SNMPAgentAuthentication auth = null;
                if (result.getReadCommunity() != null) {
                    auth = new SNMPAgentAuthentication(result.getReadCommunity(), result.getWriteCommunity());
                }
                report.append(XMLUtil.addRow(result.getIpAddress(), auth, resultString));
            }
            report.append(XMLUtil.endRange(ranges.get(i)));
        }
        boolean failed = true;
        List<NetworkIpAddressRange> rangesList = task.getRanges();
        if (!ranges.isEmpty()) {
            failed = false;
        } else {
            for (NetworkIpAddressRange range : rangesList) {
                if (!range.getEnableAutoDiscovery().booleanValue() && !range.getEnableDiscovery().booleanValue()) continue;
                failed = false;
            }
        }
        if (failed) {
            report.append(XMLUtil.failedMessage(ipresulti18n.translateString("TaskFailedReport")));
        } else {
            report.append(XMLUtil.addValue("scanned", String.valueOf(totalScanned)));
            report.append(XMLUtil.addValue("discovered", String.valueOf(discovered)));
        }
        report.append(XMLUtil.endReport());
        return report.toString();
    }

    private static String startRange(NetworkIpAddressRange range) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<range>");
        buffer.append("<range-type>").append(NetworkIpAddressRange.toStringType(range.getType())).append("</range-type>");
        buffer.append("<range-start>").append(range.getStartIp()).append("</range-start>");
        buffer.append("<range-end>").append(range.getEndIp()).append("</range-end>");
        return buffer.toString();
    }

    private static String endRange(NetworkIpAddressRange range) {
        return "</range>";
    }

    public static String addValue(String name, String value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(name).append(">").append(value).append("</").append(name).append(">");
        return buffer.toString();
    }

    public static String failedMessage(String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<failed>").append(message).append("</failed>");
        return buffer.toString();
    }
}

