/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.TaskRuntimeResultsView;
import com.bwanms.gui.taskmanager.ClientDataCallback;
import com.bwanms.gui.taskmanager.VolatileTaskRuntimeResultsForm;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.TaskPluginUtil;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileTaskRuntimeResultsFormContainer
implements ClientDataCallback {
    private static final Logger log = Logger.getLogger(VolatileTaskRuntimeResultsFormContainer.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(VolatileTaskRuntimeResultsForm.class);
    private final JDialog frame;
    VolatileTaskRuntimeResultsForm form;
    private final TaskRuntimeResultsView view;
    private final Thread sleeper;
    private final Runnable sleeperRunnable;
    private boolean shouldStop = false;
    private static int SLEEP_TIME = 200;
    final ClientData clientData = new ClientData();

    public <T extends Task> VolatileTaskRuntimeResultsFormContainer(Class<? extends Task> clazz, T task, final String userId, Component parent) {
        Window wind = SwingUtilities.getWindowAncestor(parent);
        if (parent instanceof JFrame) {
            this.frame = new JDialog((JFrame)parent);
        } else if (wind instanceof JFrame) {
            this.frame = new JDialog((JFrame)wind);
        } else if (wind instanceof JDialog) {
            this.frame = new JDialog((JDialog)wind);
        } else {
            throw new UnsupportedOperationException("OpenDialogError " + parent.getClass().getName());
        }
        this.form = new VolatileTaskRuntimeResultsForm(this);
        this.view = TaskPluginUtil.getRuntimeResultsViewerForClass(clazz);
        this.view.setTask(task);
        this.view.setClientDataCallback(this);
        this.form.setInternalPanel(this.view.getUI());
        this.sleeperRunnable = new Runnable(){

            public void run() {
                do {
                    TaskRuntimeStatus runtimeStatus;
                    if ((runtimeStatus = ServiceRegistry.getTaskManagerService().getVolatileRuntimeStatus(userId, VolatileTaskRuntimeResultsFormContainer.this.clientData.getValue())) != null) {
                        log.info((Object)(runtimeStatus.getOverallPercentage() + "% - " + runtimeStatus.isFinished()));
                        VolatileTaskRuntimeResultsFormContainer.this.view.updateResults(runtimeStatus);
                        VolatileTaskRuntimeResultsFormContainer.this.shouldStop = runtimeStatus.isFinished();
                    } else {
                        VolatileTaskRuntimeResultsFormContainer.this.shouldStop = true;
                    }
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"Sleeper was interrupted ... stopping thread");
                        VolatileTaskRuntimeResultsFormContainer.this.shouldStop = true;
                    }
                } while (!VolatileTaskRuntimeResultsFormContainer.this.shouldStop);
            }
        };
        this.sleeper = new Thread(this.sleeperRunnable, "TaskRuntimeResultsFormContainer-sleeper");
        this.sleeper.start();
        FrameUtil.runVolatileTaskRuntimeResultsForm(this.frame, i18n.translateString("RuntimeResults"), this.form, 600, 300, this.sleeper);
    }

    public void btnOKClicked() {
        this.cleanup();
    }

    public void cleanup() {
        this.sleeper.interrupt();
        this.frame.dispose();
    }

    @Override
    public void setClientDataValue(Object value) {
        this.clientData.setValue(value);
        if (this.shouldStop) {
            this.sleeperRunnable.run();
        }
    }

    private static class ClientData {
        private Object value = null;

        private ClientData() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

