/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.taskmanager.TaskRuntimeResultsFormContainer;
import com.bwanms.gui.taskmanager.VolatileTaskEditorForm;
import com.bwanms.gui.taskmanager.VolatileTaskRuntimeResultsFormContainer;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.TaskPluginUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileTaskEditorFormContainer {
    private static final Logger log = Logger.getLogger(VolatileTaskEditorFormContainer.class);
    private final JFrame frame;
    private Task task;
    private VolatileTaskEditorForm form;
    private AbstractBindedEditorView<Task> view;
    private InvalidValuesUtil invalidValuesUtil;
    private List<InvalidValue> invalidValues;
    private boolean running;
    private String userId = null;
    private VolatileTaskRuntimeResultsFormContainer runtimeContainer;
    private Runnable sleeperRunnable;
    private Thread sleeper;
    private static int SLEEP_TIME = 200;

    public <T extends Task> VolatileTaskEditorFormContainer(Class<? extends Task> clazz, T task) {
        this.task = task;
        task.setName("VolatileTask");
        this.frame = FrameUtil.createFrame();
        this.form = new VolatileTaskEditorForm(this);
        this.view = TaskPluginUtil.getViewForClass(clazz);
        this.form.setInternalPanel(this.view.getUI());
        this.form.getErrorReportEditorPane1().setTitle(this.view.getTitle());
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.invalidValues = new ArrayList<InvalidValue>();
        this.view.setEntity(this.task);
        if (!Security.getSecurity().checkPermissions(this.view.getApplicationPermission(), "write")) {
            this.form.getBtnRun().setEnabled(false);
        }
        FrameUtil.runTaskEditorFrame(this.frame, this.view.getTitle(), (JPanel)this.form, 400, 300, this);
    }

    public final boolean save() {
        this.invalidValuesUtil.clearAllInvalidValues(this.invalidValues);
        this.invalidValues = this.view.configureEntity(this.task);
        if (this.invalidValues.isEmpty()) {
            this.reportErrors();
            return true;
        }
        this.reportErrors();
        return false;
    }

    private void reportErrors() {
        this.form.getErrorReportEditorPane1().setMessages(this.invalidValues);
        this.invalidValuesUtil.reportInvalidValues(this.invalidValues);
    }

    public void btnRunClicked() {
        if (!this.running) {
            if (this.save()) {
                ServiceRegistry.getAuditLogsService().addAuditLogEntryInNewSession(Security.getSecurity().getCurrentUserId(), "TaskStart", "TaskManager", this.task.getName(), this.task.getClass().getName());
                this.userId = ServiceRegistry.getTaskManagerService().startVolatileTask(this.task);
                this.running = true;
                this.runtimeContainer = new VolatileTaskRuntimeResultsFormContainer(this.task.getClass(), this.task, this.userId, this.frame);
            }
        } else {
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskAbort", "TaskManager", this.task.getName(), this.task.getClass().getName());
            ServiceRegistry.getTaskManagerService().stopVolatileTask(this.userId);
            this.runtimeContainer.cleanup();
            this.running = false;
        }
        this.handleLocalTaskMonitoring();
    }

    private void handleLocalTaskMonitoring() {
        if (this.running) {
            this.sleeperRunnable = new Runnable(){

                public void run() {
                    do {
                        TaskRuntimeStatus runtimeStatus = ServiceRegistry.getTaskManagerService().getVolatileRuntimeStatus(VolatileTaskEditorFormContainer.this.userId, null);
                        log.info((Object)(runtimeStatus.getOverallPercentage() + "% IS FINISHED - " + runtimeStatus.isFinished()));
                        if (runtimeStatus != null) {
                            VolatileTaskEditorFormContainer.this.running = !runtimeStatus.isFinished();
                        } else {
                            VolatileTaskEditorFormContainer.this.running = false;
                        }
                        try {
                            Thread.sleep(SLEEP_TIME);
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"Sleeper was interrupted ... stopping thread");
                            VolatileTaskEditorFormContainer.this.running = false;
                        }
                    } while (VolatileTaskEditorFormContainer.this.running);
                    VolatileTaskEditorFormContainer.this.form.setTaskRunning(VolatileTaskEditorFormContainer.this.running);
                }
            };
            this.sleeper = new Thread(this.sleeperRunnable, "VolatileTaskFormContainer-sleeper");
            this.sleeper.start();
        }
        this.form.setTaskRunning(this.running);
    }

    public void btnCancelClicked() {
        this.cleanup();
    }

    public void showRuntimeStatus() {
        if (this.task.getState() != 0) {
            new TaskRuntimeResultsFormContainer(this.task.getClass(), this.task);
        }
    }

    private void cleanup() {
        this.frame.dispose();
    }

    public Task getTask() {
        return this.task;
    }

    public AbstractBindedEditorView<Task> getView() {
        return this.view;
    }
}

