/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.DialogController;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTypeConfigPanel
extends JPanel {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskTypeConfigPanel.class);
    public static final Internationalizer tI18N = Internationalizer.getInternationalizer("com.bwanms.tasks");
    private DialogController dialogController;
    private EntityManagerTableModel<String> tableModel;
    private JScrollPane scrollPane1;
    private JTable table1;
    private JButton btnOK;
    private JButton btnCancel;

    public TaskTypeConfigPanel(DialogController configForm) {
        this.initComponents();
        this.postInitComponents(configForm);
    }

    private void postInitComponents(DialogController configForm) {
        this.dialogController = configForm;
        this.tableModel = new EntityManagerTableModel<String>(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("TaskType"), String.class)}){

            @Override
            public void setRowValues(int row, String entity) {
                int col = 0;
                this.setInitialValueAt(tI18N.translateString(entity), row, col++);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            this.tableModel.setColumnReadonly(i, true);
        }
        SimpleRowTable srTable = new SimpleRowTable(this.table1, this.tableModel);
        this.table1.setSelectionMode(0);
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.table1 = new JTable();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45))}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("max(default;120dlu)"), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.table1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TaskTypeConfigPanel.this.table1MouseClicked(e);
            }
        });
        this.scrollPane1.setViewportView(this.table1);
        this.add((Component)this.scrollPane1, cc.xywh(1, 1, 7, 5));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskTypeConfigPanel.this.btnOKActionPerformed(e);
            }
        });
        this.add((Component)this.btnOK, cc.xywh(5, 7, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskTypeConfigPanel.this.btnCancelActionPerformed(e);
            }
        });
        this.add((Component)this.btnCancel, cc.xywh(7, 7, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
    }

    private void table1MouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.table1.getSelectedRow() >= 0) {
            this.dialogController.exitOK();
        }
    }

    private void btnOKActionPerformed(ActionEvent e) {
        if (this.table1.getSelectedRow() >= 0) {
            this.dialogController.exitOK();
        }
    }

    private void btnCancelActionPerformed(ActionEvent e) {
        this.dialogController.exitCancel();
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JButton getBtnOK() {
        return this.btnOK;
    }

    public EntityManagerTableModel<String> getTableModel() {
        return this.tableModel;
    }

    public JTable getTable1() {
        return this.table1;
    }
}

