/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskWizardContainer;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.DialogController;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskTypeConfigPanel;
import com.bwanms.model.Task;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.TaskPluginUtil;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class TaskTypeConfigForm
implements DialogController {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskTypeConfigForm.class);
    private String type;
    private final JDialog dialog;
    private String result;
    private TaskTypeConfigPanel panel;

    public TaskTypeConfigForm(String result, JFrame frame1) {
        this.result = result;
        this.dialog = new JDialog(frame1);
        this.dialog.setResizable(true);
        this.run();
    }

    public void exitOK() {
        this.type = this.panel.getTableModel().getEntity(this.panel.getTable1().getSelectedRow());
        this.dialog.dispose();
        try {
            this.openTaskEditor();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void exitCancel() {
        this.dialog.dispose();
    }

    private void run() {
        this.panel = new TaskTypeConfigPanel(this);
        Map<String, Boolean> taskTypes = TaskPluginUtil.getTaskTypes();
        for (String type : taskTypes.keySet()) {
            if (!taskTypes.get(type).booleanValue()) continue;
            this.panel.getTableModel().addRow(type, type);
        }
        FrameUtil.runDialog(this.dialog, i18n.translateString("TaskType"), this.panel, 400, 250);
    }

    private void openTaskEditor() throws InstantiationException, IllegalAccessException {
        Class<? extends Task> clazz = TaskPluginUtil.getTaskForType(this.type);
        if (PerformanceCollectionGenericTask.class.isAssignableFrom(clazz)) {
            try {
                PerformanceCollectionGenericTask task = (PerformanceCollectionGenericTask)clazz.newInstance();
                PMCollectionTaskWizardContainer wizard = new PMCollectionTaskWizardContainer(task);
                wizard.setWizardMode(true);
                wizard.runEditor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new TaskEditorFormContainer(clazz, clazz.newInstance());
        }
    }
}

