/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.TaskRuntimeResultsView;
import com.bwanms.gui.taskmanager.ClientDataCallback;
import com.bwanms.gui.taskmanager.TaskResultsEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskRuntimeResultsForm;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.TaskPluginUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRuntimeResultsFormContainer
implements ClientDataCallback {
    private static final Logger log = Logger.getLogger(TaskRuntimeResultsFormContainer.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskRuntimeResultsForm.class);
    private final JFrame frame;
    private final Task task;
    TaskRuntimeResultsForm form;
    private final TaskRuntimeResultsView view;
    private final Thread sleeper;
    private final Runnable sleeperRunnable;
    private boolean shouldStop = false;
    private static int SLEEP_TIME = 200;
    final ClientData clientData = new ClientData();
    private KeyAdapter theListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TaskRuntimeResultsFormContainer.this.cleanup();
            }
        }
    };

    public <T extends Task> TaskRuntimeResultsFormContainer(Class<? extends Task> clazz, T task) {
        this.frame = FrameUtil.createFrame();
        this.task = task;
        this.form = new TaskRuntimeResultsForm(this);
        this.view = TaskPluginUtil.getRuntimeResultsViewerForClass(clazz);
        this.view.setTask(task);
        this.view.setClientDataCallback(this);
        this.form.setInternalPanel(this.view.getUI());
        this.sleeperRunnable = new Runnable(){

            public void run() {
                do {
                    TaskRuntimeStatus runtimeStatus;
                    if ((runtimeStatus = ServiceRegistry.getTaskManagerService().getRuntimeStatus(TaskRuntimeResultsFormContainer.this.task.getId(), TaskRuntimeResultsFormContainer.this.clientData.getValue())) != null) {
                        TaskRuntimeResultsFormContainer.this.view.updateResults(runtimeStatus);
                        TaskRuntimeResultsFormContainer.this.shouldStop = runtimeStatus.isFinished();
                    } else {
                        TaskRuntimeResultsFormContainer.this.shouldStop = true;
                    }
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"Sleeper was interrupted ... stopping thread");
                        TaskRuntimeResultsFormContainer.this.shouldStop = true;
                    }
                } while (!TaskRuntimeResultsFormContainer.this.shouldStop);
                TaskRuntimeResultsFormContainer.this.form.getBtnReport().setEnabled(true);
            }
        };
        this.sleeper = new Thread(this.sleeperRunnable, "TaskRuntimeResultsFormContainer-sleeper");
        FrameUtil.runTaskRuntimeResultsForm(this.frame, i18n.translateString("RuntimeResults"), this.form, 600, 300, this.sleeper);
        FrameUtil.addKeyListenerRecursively(this.frame, this.theListener);
        this.sleeper.start();
    }

    public void btnOKClicked() {
        this.cleanup();
    }

    public void showReport() {
        TaskRunResult result = ServiceRegistry.getTaskManagerService().getLastRunResult(this.task.getId());
        new TaskResultsEditorFormContainer(result);
        this.cleanup();
    }

    private void cleanup() {
        this.sleeper.interrupt();
        this.frame.dispose();
    }

    @Override
    public void setClientDataValue(Object value) {
        this.clientData.setValue(value);
        if (this.shouldStop) {
            this.sleeperRunnable.run();
        }
    }

    private static class ClientData {
        private Object value = null;

        private ClientData() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

