/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.SimpleTableModel;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.TaskResultsEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskResultsTablePanel;
import com.bwanms.gui.taskmanager.xsl.XSLTransformer;
import com.bwanms.model.TaskRunResult;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ReportUtil;
import com.bwanms.util.TaskPluginUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTable;

public class TaskResultsTablePanelController {
    private TaskResultsTablePanel form;
    private static Internationalizer i18n = Internationalizer.getInternationalizer(TaskResultsTablePanelController.class);

    public TaskResultsTablePanelController(TaskResultsTablePanel form) {
        this.form = form;
    }

    public void btnViewMouseClicked() {
        int[] rows = this.form.getTable().getSelectedRows();
        if (rows.length != 1) {
            MessageBox.Info.quickShow(this.form, i18n.translateString("InvalidHistoryReportSelection"));
        } else {
            int row = rows[0];
            if (!TaskManagerMediator.taskReportEditorOpenedForEdit(this.form.getTableModel().getRowValue(row))) {
                TaskResultsEditorFormContainer taskResultsEditorFormContainer = new TaskResultsEditorFormContainer(this.form.getTableModel().getRowValue(row));
            } else {
                TaskManagerMediator.getReportEditor(this.form.getTableModel().getRowValue(row)).requestFocus();
            }
        }
    }

    public void btnSaveClicked() {
        int[] rows = this.form.getTable().getSelectedRows();
        if (rows.length != 1) {
            MessageBox.Info.quickShow(this.form, i18n.translateString("InvalidHistoryReportSelection"));
        } else {
            int row = rows[0];
            TaskRunResult runResults = this.form.getTableModel().getRowValue(row);
            XSLTransformer xslTransformer = TaskPluginUtil.getXSLTransformerForClass(runResults.getTask().getClass());
            xslTransformer.setContent(runResults.getReport());
            String content = xslTransformer.transform();
            ReportUtil.exportToHTMLFile(content, xslTransformer, this.form);
        }
    }

    public void btnDeleteClicked() {
        try {
            this.deleteFromHistory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteFromHistory() throws Exception {
        JTable table = this.form.getTable();
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length > 0) {
            int i;
            Arrays.sort(selectedRows);
            EntityManagerService commandService = ServiceRegistry.getEntityManagerService();
            ArrayList<TaskRunResult> taskResults = new ArrayList<TaskRunResult>();
            SimpleTableModel tableModel = this.form.getTableModel();
            for (i = selectedRows.length - 1; i >= 0; --i) {
                taskResults.add(tableModel.getRowValue(selectedRows[i]));
            }
            commandService.deleteAll(taskResults);
            for (i = selectedRows.length - 1; i >= 0; --i) {
                tableModel.remove(selectedRows[i]);
            }
        } else {
            MessageBox.Info.quickShow(this.form, i18n.translateString("InvalidHistorySelection"));
        }
    }
}

