/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.TaskResultsTablePanel;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRunResult;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;

public class TaskResultsTableForm {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskResultsTableForm.class);
    private final JFrame frame;
    private TaskResultsTablePanel panel;
    private Task task;

    public TaskResultsTableForm(Task task) {
        this.task = task;
        this.frame = FrameUtil.createFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TaskResultsTableForm.this.cleanup();
            }
        });
        TaskManagerMediator.addTaskHistoryEditor(this);
    }

    public long getId() {
        return this.task.getId();
    }

    public void cleanup() {
        TaskManagerMediator.removeTaskHistoryEditor(this);
    }

    public void requestFocus() {
        this.frame.setState(0);
        this.frame.requestFocus();
    }

    public void run(int width, int height) {
        this.panel = new TaskResultsTablePanel(this);
        List<TaskRunResult> results = ServiceRegistry.getTaskManagerService().getHistory(this.task.getId());
        if (results != null) {
            for (TaskRunResult result : results) {
                this.panel.getTableModel().addRow(result);
            }
        }
        FrameUtil.runFrame(this.frame, i18n.translateString("TaskResults"), this.panel, width, height);
    }

    public void btnOKClicked() {
        this.cleanup();
        this.frame.dispose();
    }
}

