/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.TaskResultsEditorForm;
import com.bwanms.gui.taskmanager.TaskResultsView;
import com.bwanms.gui.taskmanager.xsl.XSLTransformer;
import com.bwanms.model.TaskRunResult;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ReportUtil;
import com.bwanms.util.TaskPluginUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class TaskResultsEditorFormContainer {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskResultsView.class);
    private static final Logger log = Logger.getLogger(TaskResultsEditorFormContainer.class);
    private TaskRunResult runResults;
    private JFrame frame;
    private TaskResultsEditorForm form;
    private TaskResultsView view;
    private XSLTransformer xslTransformer;
    private String html;
    private KeyAdapter theListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TaskResultsEditorFormContainer.this.cleanup();
                TaskResultsEditorFormContainer.this.frame.dispose();
            }
        }
    };

    public void requestFocus() {
        this.frame.setState(0);
        this.frame.requestFocus();
    }

    public TaskResultsEditorFormContainer(TaskRunResult runResults) {
        this.frame = FrameUtil.createFrame();
        this.form = new TaskResultsEditorForm(this);
        this.runResults = runResults;
        TaskManagerMediator.addTaskReportEditor(this);
        this.view = TaskPluginUtil.getResultViewerForClass(runResults.getTask().getClass());
        this.xslTransformer = TaskPluginUtil.getXSLTransformerForClass(runResults.getTask().getClass());
        this.xslTransformer.setContent(runResults.getReport());
        this.html = this.xslTransformer.transform();
        log.info((Object)("<REPORT SIZE IS " + this.html.length() + ">"));
        if (this.html.length() < 200000) {
            this.form.setInternalPanel(this.view.getUI(this.html));
            FrameUtil.runFrame(this.frame, this.view.getTitle(), this.form, 760, 575);
        } else if (MessageBox.Confirm.showResult(null, i18n.translateString("TooBigSave"), this.view.getTitle())) {
            ReportUtil.exportToHTMLFile(this.html, this.xslTransformer, this.form);
            this.cleanup();
        }
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TaskResultsEditorFormContainer.this.cleanup();
            }
        });
        FrameUtil.addKeyListenerRecursively(this.frame, this.theListener);
        this.frame.setResizable(true);
    }

    public long getEntityId() {
        return this.runResults.getId();
    }

    public void btnOKClicked() {
        this.cleanup();
        this.frame.dispose();
    }

    public void cleanup() {
        TaskManagerMediator.removeTaskReportEditor(this);
    }

    public void btnSaveClicked() {
        ReportUtil.exportToHTMLFile(this.html, this.xslTransformer, this.form);
    }
}

