/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.model.Task;
import com.bwanms.model.TaskObserver;
import com.bwanms.platform.PlatformFactory;
import java.util.ArrayList;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

class TaskObserverNotifyer
implements MessageListener {
    private static final transient Logger log = Logger.getLogger(TaskObserverNotifyer.class);
    private ArrayList<TaskObserver> observers = new ArrayList();

    public TaskObserverNotifyer() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/TaskObserverTopic", this);
        log.info((Object)"REGISTERED ON TOPIC AND LISTENING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservers(TaskObserver observer) {
        ArrayList<TaskObserver> arrayList = this.observers;
        synchronized (arrayList) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservers(TaskObserver observer) {
        ArrayList<TaskObserver> arrayList = this.observers;
        synchronized (arrayList) {
            this.observers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            Task task = (Task)((ObjectMessage)message).getObject();
            TaskManagerMediator.notifyEditors(task);
            ArrayList<TaskObserver> arrayList = this.observers;
            synchronized (arrayList) {
                for (TaskObserver observer : this.observers) {
                    observer.taskStateChanged(task);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
    }
}

