/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskWizardContainer;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.scheduler.TaskScheduleEditorContainer;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.TaskManagerPanel;
import com.bwanms.gui.taskmanager.TaskResultsEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskResultsTableForm;
import com.bwanms.gui.taskmanager.TaskRuntimeResultsFormContainer;
import com.bwanms.gui.taskmanager.TaskTypeConfigForm;
import com.bwanms.model.SystemTask;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TaskPluginUtil;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TaskManagerPanelController
implements TableModelListener {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskManagerPanelController.class);
    private TaskManagerPanel form;

    public TaskManagerPanelController(TaskManagerPanel form) {
        this.form = form;
    }

    public void controlTableButtons() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            this.controlTableButtons(false, false, false, false, false);
            return;
        }
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length == 1) {
            Task task = this.form.getTableModel().getTask(row);
            switch (task.getState()) {
                case 0: {
                    this.controlTableButtons(true, !(task instanceof SystemTask), true, false, true);
                    break;
                }
                case 2: {
                    this.controlTableButtons(TaskPluginUtil.getRuntimeResultsViewerForClass(task.getClass()) != null, false, false, true, false);
                    break;
                }
                case 1: {
                    this.controlTableButtons(false, false, false, false, false);
                }
            }
        } else {
            boolean del = true;
            for (int temp : rows) {
                Task task = this.form.getTableModel().getTask(temp);
                if (task.getState() == 0 && !(task instanceof SystemTask)) continue;
                del = false;
                break;
            }
            this.controlTableButtons(false, del, false, false, false);
        }
    }

    private void controlTableButtons(boolean modify, boolean delete, boolean run, boolean abort, boolean schedule) {
        this.form.getBtnModify().setEnabled(modify);
        this.form.getBtnRun().setEnabled(run);
        this.form.getBtnAbort().setEnabled(abort);
        this.form.getBtnSchedule().setEnabled(schedule);
        int row = this.getTable().getSelectedRow();
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length == 1) {
            if (row < 0) {
                this.form.getBtnDelete().setEnabled(false);
                this.form.getBtnReport().setEnabled(false);
                this.form.getBtnHistory().setEnabled(false);
                this.form.getBtnClearSchedule().setEnabled(false);
            } else {
                Task task = this.form.getTableModel().getTask(row);
                this.form.getBtnDelete().setEnabled(delete);
                this.form.getBtnReport().setEnabled(task.getLastRunResult() != 0);
                this.form.getBtnHistory().setEnabled(task.getLastRunResult() != 0);
                this.form.getBtnClearSchedule().setEnabled(task.getSchedule() != null && task.getState() == 0);
            }
        } else {
            this.form.getBtnDelete().setEnabled(delete);
            this.form.getBtnReport().setEnabled(false);
            this.form.getBtnHistory().setEnabled(false);
            this.form.getBtnClearSchedule().setEnabled(false);
        }
        if (!Security.getSecurity().checkPermissions("Av:ConfigureTasks", "write")) {
            this.form.getBtnRun().setEnabled(false);
            this.form.getBtnSchedule().setEnabled(false);
        }
        if (!Security.getSecurity().checkPermissions("Av:ConfigureTasks", "add")) {
            this.form.getBtnNew().setEnabled(false);
        }
        if (!Security.getSecurity().checkPermissions("Av:ConfigureTasks", "delete")) {
            this.form.getBtnDelete().setEnabled(false);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.controlTableButtons();
    }

    public void abortTask() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        if (MessageBox.Confirm.showResult(this.form, i18n.translateString("ConfirmAbort", task.getName()), i18n.translateString("ConfirmAbortTask"))) {
            TaskManagerMediator.stopTask(task);
        }
    }

    public void runTask() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        this.form.getBtnRun().setEnabled(false);
        TaskManagerMediator.startTask(task);
    }

    public void newTask() {
        String taskType = null;
        new TaskTypeConfigForm(taskType, (JFrame)SwingUtilities.getWindowAncestor(this.form));
    }

    public void modifyTask() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        if (task.getState() == 0) {
            if (!TaskManagerMediator.taskOpenedForEdit(task)) {
                if (PerformanceCollectionGenericTask.class.isAssignableFrom(task.getClass())) {
                    try {
                        PMCollectionTaskWizardContainer wizard = new PMCollectionTaskWizardContainer((PerformanceCollectionGenericTask)task);
                        wizard.setWizardMode(false);
                        wizard.runEditor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    new TaskEditorFormContainer(task.getClass(), task);
                }
            } else if (PerformanceCollectionGenericTask.class.isAssignableFrom(task.getClass())) {
                try {
                    PMCollectionTaskWizardContainer wizard = (PMCollectionTaskWizardContainer)TaskManagerMediator.getTaskEditor(task);
                    wizard.runEditor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                TaskEditorFormContainer taskEditor = (TaskEditorFormContainer)TaskManagerMediator.getTaskEditor(task);
                taskEditor.requestFocus();
            }
        } else {
            new TaskRuntimeResultsFormContainer(task.getClass(), task);
        }
    }

    public void deleteTask() {
        final int[] rows = this.getTable().getSelectedRows();
        if (rows == null || rows.length < 1) {
            return;
        }
        if (rows.length > 1) {
            final ArrayList<Task> tasks = new ArrayList<Task>();
            for (int row : rows) {
                Task task = this.form.getTableModel().getTask(row);
                tasks.add(task);
            }
            AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                public String getTitle() {
                    return i18n.translateString("DeleteTask");
                }

                public boolean isCancelable() {
                    return true;
                }

                public long getMaxProgress() {
                    return rows.length;
                }

                public void run() {
                    long progress = 0L;
                    for (Task task : tasks) {
                        if (this.shouldCancel) {
                            this.monitor.logMessage(i18n.translateString("Canceled"));
                            break;
                        }
                        this.monitor.updateProgress(++progress, i18n.translateString("DeletingTask", task.getName()));
                        try {
                            if (task.getSchedule() != null) {
                                this.monitor.logMessage(i18n.translateString("TaskScheduled", task.getName()));
                                continue;
                            }
                            TaskManagerMediator.deleteTask(task);
                            this.monitor.logMessage(i18n.translateString("DeletedTask", task.getName()));
                        }
                        catch (Exception ex) {
                            this.monitor.logMessage(i18n.translateString("FailedToDeletTask", task.getName()));
                        }
                    }
                    this.monitor.operationCompleted(false);
                }
            };
            if (MessageBox.Confirm.showResult(this.form, i18n.translateString("AreYouSureYouWantToDeleteSelectedTasks"), i18n.translateString("ConfirmTasksDelete"))) {
                LongOperationUtil.startDetailLongOperationDialog(this.form, deleteOperation);
            }
        } else {
            int row = this.getTable().getSelectedRow();
            Task task = this.form.getTableModel().getTask(row);
            if (task.getSchedule() == null) {
                if (MessageBox.Confirm.showResult(this.form, i18n.translateString("ConfirmDelete", task.getName()), i18n.translateString("ConfirmTaskDelete"))) {
                    TaskManagerMediator.deleteTask(task);
                }
            } else {
                MessageBox.Alert.showResult(this.form, i18n.translateString("TaskScheduled", task.getName()));
            }
        }
    }

    public void taskHistory() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        if (!TaskManagerMediator.taskHistoryOpenedForEdit(task)) {
            new TaskResultsTableForm(task).run(530, 400);
        } else {
            TaskManagerMediator.getHistoryEditor(task).requestFocus();
        }
        this.controlTableButtons();
    }

    private JTable getTable() {
        return this.form.getTable2();
    }

    public void showReport() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        TaskRunResult result = ServiceRegistry.getTaskManagerService().getLastRunResult(task.getId());
        if (!TaskManagerMediator.taskReportEditorOpenedForEdit(result)) {
            new TaskResultsEditorFormContainer(result);
        } else {
            TaskManagerMediator.getReportEditor(result).requestFocus();
        }
        this.controlTableButtons();
    }

    public void scheduleTask() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        TaskScheduleEditorContainer schEditor = this.getOpenedScheduleEditor(task);
        if (schEditor != null) {
            schEditor.requestFocus();
        } else {
            TaskManagerMediator.scheduleTask(task);
        }
        this.controlTableButtons();
    }

    public void clearTaskSchedule() {
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        Task task = this.form.getTableModel().getTask(row);
        TaskScheduleEditorContainer schEditor = this.getOpenedScheduleEditor(task);
        if (schEditor != null) {
            MessageBox.WarnConfirm.quickShow(this.form, i18n.translateString("CannotClearTaskScheduler"));
        } else {
            TaskManagerMediator.clearTaskSchedule(task);
            this.controlTableButtons();
        }
    }

    private TaskScheduleEditorContainer getOpenedScheduleEditor(Task task) {
        if (TaskManagerMediator.taskScheduleOpenedForEdit(task)) {
            return (TaskScheduleEditorContainer)TaskManagerMediator.getTaskScheduleEditor(task);
        }
        return null;
    }
}

