/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.wizard.EntityWizardEditorContainer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.scheduler.TaskScheduleEditorContainer;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskManagerPanel;
import com.bwanms.gui.taskmanager.TaskObserverNotifyer;
import com.bwanms.gui.taskmanager.TaskResultsEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskResultsTableForm;
import com.bwanms.model.ScheduleRecurrence;
import com.bwanms.model.Task;
import com.bwanms.model.TaskObserver;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.TaskManagerTableModel;
import com.bwanms.util.MessageBox;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerMediator
implements TaskObserver,
ManagerView {
    private static final Logger log = Logger.getLogger(TaskManagerMediator.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskManagerMediator.class);
    private static Map<Long, TaskObserver> editors = new HashMap<Long, TaskObserver>();
    private static Map<Long, TaskObserver> schEditors = new HashMap<Long, TaskObserver>();
    private static Map<Long, TaskResultsEditorFormContainer> reportEditors = new HashMap<Long, TaskResultsEditorFormContainer>();
    private static Map<Long, TaskResultsTableForm> historyEditors = new HashMap<Long, TaskResultsTableForm>();
    private static TaskObserverNotifyer notifyer;
    private static String focusTaskName;
    private TaskManagerPanel form = new TaskManagerPanel();

    public TaskManagerMediator() {
        this.registerListener();
        this.addTableSorting();
        this.fillUI();
    }

    private void addTableSorting() {
        this.form.getTable2().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                int column = TaskManagerMediator.this.form.getTable2().getTableHeader().columnAtPoint(new Point(arg0.getX(), arg0.getY()));
                TableColumn tblColumn = TaskManagerMediator.this.form.getTable2().getTableHeader().getColumnModel().getColumn(column);
                TaskManagerMediator.this.sortByColumn(tblColumn.getModelIndex());
            }
        });
    }

    protected void sortByColumn(int modelIndex) {
        ((TaskManagerTableModel)this.form.getTable2().getModel()).sortByColumn(modelIndex);
    }

    @Override
    public TaskManagerPanel getUI() {
        return this.form;
    }

    @Override
    public void taskStateChanged(Task task) {
        try {
            log.debug((Object)("TASK STATE CHANGED " + task.getState()));
            if (task.getState() == 3) {
                this.form.getTableModel().removeRow(task);
            } else {
                int row = this.form.getTableModel().updateRow(task);
                if (focusTaskName != null) {
                    ListSelectionModel selection = this.form.getTable2().getSelectionModel();
                    selection.setSelectionInterval(row, row);
                    focusTaskName = null;
                }
            }
            this.form.getController().controlTableButtons();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void fillUI() {
        TaskManagerTableModel model = this.form.getTableModel();
        model.clearTable();
        List<Task> tasks = ServiceRegistry.getTaskManagerService().retrieveTasks();
        for (Task task : tasks) {
            model.addRow(task);
        }
    }

    private void registerListener() {
        if (notifyer == null) {
            notifyer = new TaskObserverNotifyer();
        }
        notifyer.addObservers(this);
    }

    @Override
    public List<Serializable> getSelection() {
        return null;
    }

    @Override
    public List<EntityManagerRow> getSelectionData() {
        return null;
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("TaskManager");
    }

    public EntityManagerRow fetchRow(Class<? extends Serializable> clazz, Serializable id) {
        return null;
    }

    @Override
    public List<EntityManagerRow> getData() {
        return null;
    }

    @Override
    public void performQuery() {
        log.error((Object)"Not Implemented");
    }

    @Override
    public void cleanup() {
        notifyer.removeObservers(this);
        notifyer.closeConnection();
    }

    public static void startTask(Task task) {
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskStart", "TaskManager", task.getName(), task.getClass().getName());
        ServiceRegistry.getTaskManagerService().startTask(task.getId());
    }

    public static void stopTask(Task task) {
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskAbort", "TaskManager", task.getName(), task.getClass().getName());
        ServiceRegistry.getTaskManagerService().stopTask(task.getId());
    }

    public static void deleteTask(Task task) {
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskDelete", "TaskManager", task.getName(), task.getClass().getName());
        ServiceRegistry.getTaskManagerService().deleteTask(task.getId());
    }

    public static void scheduleTask(Task task) {
        TaskSchedule schedule;
        if (task.getSchedule() != null) {
            schedule = task.getSchedule();
        } else {
            schedule = new TaskSchedule();
            if (PerformanceCollectionGenericTask.class.isAssignableFrom(task.getClass())) {
                ScheduleRecurrence scheduleRecurrence = new ScheduleRecurrence();
                scheduleRecurrence.setType(1);
                scheduleRecurrence.setEndType(0);
                scheduleRecurrence.setEndValues(0, null, null);
                scheduleRecurrence.setParam2(15);
                schedule.setRecurrence(scheduleRecurrence);
            }
            schedule.setTask(task);
        }
        try {
            new TaskScheduleEditorContainer(schedule);
        }
        catch (ServiceException ex) {
            MessageBox.Error.quickShow(null, ex.getMessage());
        }
    }

    public static void addTaskEditor(TaskEditorFormContainer editor) {
        log.debug((Object)("ADDING EDITOR FOR TASK " + editor.getTask().getName()));
        editors.put(editor.getTask().getId(), editor);
    }

    public static void addTaskEditor(EntityWizardEditorContainer wizard) {
        log.debug((Object)("ADDING EDITOR FOR TASK " + wizard.getEntityName()));
        editors.put(wizard.getEntityId(), wizard);
    }

    public static void removeTaskEditor(TaskEditorFormContainer editor) {
        editors.remove(editor.getTask().getId());
    }

    public static void removeTaskEditor(EntityWizardEditorContainer wizard) {
        editors.remove(wizard.getEntityId());
    }

    public static boolean taskOpenedForEdit(Task task) {
        return editors.containsKey(task.getId());
    }

    public static TaskObserver getTaskEditor(Task task) {
        return editors.get(task.getId());
    }

    public static void addTaskScheduleEditor(TaskScheduleEditorContainer editor) {
        log.debug((Object)("ADDING EDITOR FOR SCHEDULE OF TASK " + editor.getEntityId()));
        schEditors.put(editor.getTaskId(), editor);
    }

    public static void removeTaskScheduleEditor(TaskScheduleEditorContainer editor) {
        schEditors.remove(editor.getTaskId());
    }

    public static boolean taskScheduleOpenedForEdit(Task task) {
        return schEditors.containsKey(task.getId());
    }

    public static TaskObserver getTaskScheduleEditor(Task task) {
        return schEditors.get(task.getId());
    }

    public static void addTaskHistoryEditor(TaskResultsTableForm editor) {
        log.debug((Object)("ADDING EDITOR FOR TaskHistoryEditor OF TASK " + editor.getId()));
        historyEditors.put(editor.getId(), editor);
    }

    public static void removeTaskHistoryEditor(TaskResultsTableForm editor) {
        historyEditors.remove(editor.getId());
    }

    public static boolean taskHistoryOpenedForEdit(Task task) {
        return historyEditors.containsKey(task.getId());
    }

    public static TaskResultsTableForm getHistoryEditor(Task task) {
        return historyEditors.get(task.getId());
    }

    public static void addTaskReportEditor(TaskResultsEditorFormContainer editor) {
        log.debug((Object)("ADDING EDITOR FOR TaskReport OF TASK " + editor.getEntityId()));
        reportEditors.put(editor.getEntityId(), editor);
    }

    public static void removeTaskReportEditor(TaskResultsEditorFormContainer editor) {
        reportEditors.remove(editor.getEntityId());
    }

    public static boolean taskReportEditorOpenedForEdit(TaskRunResult result) {
        return reportEditors.containsKey(result.getId());
    }

    public static TaskResultsEditorFormContainer getReportEditor(TaskRunResult result) {
        return reportEditors.get(result.getId());
    }

    public static void clearTaskSchedule(Task task) {
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskUnschedule", "TaskManager", task.getName(), task.getClass().getName());
        ServiceRegistry.getTaskManagerService().updateTask(task, 1);
    }

    public static void focusTask(String name) {
        focusTaskName = name;
    }

    static void notifyEditors(Task task) {
        TaskObserver editor = editors.get(task.getId());
        if (editor != null) {
            log.debug((Object)("UPDATING EDITOR FOR TASK " + task.getName()));
            editor.taskStateChanged(task);
        }
        if ((editor = schEditors.get(task.getId())) != null) {
            log.debug((Object)("UPDATING SCH EDITOR FOR TASK " + task.getName()));
            editor.taskStateChanged(task);
        }
    }
}

