/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.scheduler.TaskScheduleEditorContainer;
import com.bwanms.gui.taskmanager.TaskEditorForm;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.TaskResultsEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskRuntimeResultsFormContainer;
import com.bwanms.model.Task;
import com.bwanms.model.TaskObserver;
import com.bwanms.model.TaskRunResult;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.ServerValidationException;
import com.bwanms.util.TaskPluginUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditorFormContainer
implements TaskObserver {
    private static final Logger log = Logger.getLogger(TaskEditorFormContainer.class);
    private static final String platformType = System.getProperty("com.bwanms.platform", "remote");
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskEditorForm.class);
    private final JFrame frame;
    private Task task;
    protected TaskEditorForm form;
    protected AbstractBindedEditorView<Task> view;
    protected InvalidValuesUtil invalidValuesUtil;
    protected List<InvalidValue> invalidValues;

    public void requestFocus() {
        this.frame.setState(0);
        this.frame.requestFocus();
    }

    public <T extends Task> TaskEditorFormContainer(Class<? extends Task> clazz, T task) {
        this(clazz, task, null);
    }

    public <T extends Task> TaskEditorFormContainer(Class<? extends Task> clazz, T task, ManagerView manager) {
        Task dbTask = ServiceRegistry.getTaskManagerService().retrieveTask(task.getId());
        this.task = null != dbTask ? dbTask : task;
        this.form = new TaskEditorForm(this);
        if (platformType.equalsIgnoreCase("local")) {
            this.frame = FrameUtil.createModalFrame((Window)manager.getUI().getTopLevelAncestor(), true);
            this.form.getBtnCancel().setVisible(false);
            this.form.getBtnOK().setVisible(false);
        } else {
            this.frame = FrameUtil.createModalFrame(null, true);
        }
        this.updateStatus();
        this.updateButtons();
        this.view = TaskPluginUtil.getViewForClass(clazz);
        this.form.setInternalPanel(this.view.getUI());
        this.form.getErrorReportEditorPane1().setTitle(this.view.getTitle());
        if (!Security.getSecurity().checkPermissions(this.view.getApplicationPermission(), "write")) {
            this.form.setBtnOKEnabled(false);
            this.form.setBtnRunEnabled(false);
        }
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.invalidValues = new ArrayList<InvalidValue>();
        this.view.setEntity(this.task);
        FrameUtil.runTaskEditorFrame(this.frame, this.view.getTitle(), (JPanel)this.form, 400, 300, this);
        if (this.task.getId() != 0L) {
            TaskManagerMediator.addTaskEditor(this);
        }
    }

    public final boolean save(boolean refreshTask) {
        this.form.getErrorReportEditorPane1().removeMessages();
        this.invalidValuesUtil.clearReportedInvalidValues(this.invalidValues);
        this.invalidValues = this.view.configureEntity(this.task);
        if (this.invalidValues.isEmpty()) {
            try {
                String taskTypeForAuditLogs = "TaskUpdate";
                if (this.task.getId() == 0L) {
                    this.task.setCreatedBy(Security.getSecurity().getCurrentUserId());
                    taskTypeForAuditLogs = "TaskCreate";
                }
                this.task.setModifiedBy(Security.getSecurity().getCurrentUserId());
                TaskManagerMediator.focusTask(this.task.getName());
                this.task = ServiceRegistry.getTaskManagerService().validateAndUpdateTask(this.task, -1);
                if (refreshTask) {
                    this.task = ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
                    this.view.setEntity(this.task);
                }
                if (null != this.task) {
                    ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), taskTypeForAuditLogs, "TaskManager", this.task.getName(), this.task.getClass().getName());
                }
                return true;
            }
            catch (ServerValidationException e) {
                TaskManagerMediator.focusTask(null);
                this.invalidValues = e.getInvalidValues();
                this.view.processExternalInvalidValues(this.invalidValues);
            }
        }
        this.reportErrors();
        return false;
    }

    private void reportErrors() {
        this.form.getErrorReportEditorPane1().setMessages(this.invalidValues);
        this.invalidValuesUtil.reportInvalidValues(this.invalidValues);
    }

    public void btnOKClicked() {
        if (this.save(false)) {
            this.cleanup();
        }
    }

    public void btnRunClicked() {
        if (this.save(true)) {
            this.form.setBtnRunEnabled(false);
            TaskManagerMediator.addTaskEditor(this);
            TaskManagerMediator.startTask(this.task);
        }
    }

    public void btnReportClicked() {
        TaskRunResult result = ServiceRegistry.getTaskManagerService().getLastRunResult(this.task.getId());
        if (!TaskManagerMediator.taskReportEditorOpenedForEdit(result)) {
            new TaskResultsEditorFormContainer(result);
        } else {
            TaskManagerMediator.getReportEditor(result).requestFocus();
        }
    }

    public void btnScheduleClicked() {
        if (this.task.getId() == 0L) {
            if (FrameUtil.showConfirmation(this.getFrame(), i18n.translateString("TaskNotSaved")) && this.save(true)) {
                this.runTaskScheduleEditorContainer();
            }
        } else {
            this.runTaskScheduleEditorContainer();
        }
    }

    private void runTaskScheduleEditorContainer() {
        TaskScheduleEditorContainer schEditor = (TaskScheduleEditorContainer)TaskManagerMediator.getTaskScheduleEditor(this.task);
        if (schEditor != null) {
            schEditor.requestFocus();
        } else {
            TaskManagerMediator.addTaskEditor(this);
            TaskManagerMediator.scheduleTask(this.task);
        }
    }

    public void btnCancelClicked() {
        this.cleanup();
    }

    public void showRuntimeStatus() {
        if (this.task.getState() != 0) {
            new TaskRuntimeResultsFormContainer(this.task.getClass(), this.task);
        }
    }

    @Override
    public synchronized void taskStateChanged(Task task) {
        log.debug((Object)("TASK STATE CHANGED in editor of task " + this.task.getName() + " - " + task.getState()));
        if (this.task.getId() == task.getId()) {
            this.task.setState(task.getState());
            this.task.setLastRunResult(task.getLastRunResult());
            this.task.setLastRun(task.getLastRun());
            this.task.setTaskRunResults(task.getTaskRunResults());
            this.task.setSchedule(task.getSchedule());
            this.updateButtons();
            this.updateStatus();
        }
    }

    private synchronized void updateStatus() {
        if (!this.form.getTxtStatus().getText().equals("")) {
            this.form.getTxtStatus().setText("");
        }
        this.form.getTxtStatus().setText(Task.getStateString(this.task.getState()));
    }

    private void updateButtons() {
        if (this.task.getState() != 0) {
            this.form.setBtnRunEnabled(false);
            this.form.setBtnOKEnabled(false);
            this.form.setBtnScheduleEnabled(false);
        } else {
            this.form.setBtnRunEnabled(true);
            this.form.setBtnOKEnabled(true);
            this.form.setBtnScheduleEnabled(true);
        }
        if (this.task.getLastRunResult() != 0 && this.task.getState() == 0) {
            this.form.setBtnReport(true);
        } else {
            this.form.setBtnReport(false);
        }
    }

    private void cleanup() {
        TaskManagerMediator.removeTaskEditor(this);
        this.frame.dispose();
    }

    public Task getTask() {
        return this.task;
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

