/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.taskmanager;

import com.bwanms.gui.taskmanager.TaskResultsTablePanel;
import com.bwanms.model.TaskRunResult;
import com.bwanms.util.DateFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class SimpleTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5899843846777857075L;
    private List<Object[]> _rows;
    private List<String> _columns = new ArrayList<String>();
    private Map<Integer, TaskRunResult> _cache;

    public SimpleTableModel() {
        this._rows = new ArrayList<Object[]>();
        this._cache = new HashMap<Integer, TaskRunResult>();
    }

    public String getColumnName(int column) {
        return this._columns.get(column);
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public void addRow(TaskRunResult value) {
        Date startDate = new Date(value.getStart());
        Date endDate = new Date(value.getEnd());
        String startDateString = DateFormatter.format(startDate);
        String endDateString = DateFormatter.format(endDate);
        String result = "";
        if (value.getResult() == 1) {
            result = TaskResultsTablePanel.i18n.translateString("Completed");
        } else if (value.getResult() == 4) {
            result = TaskResultsTablePanel.i18n.translateString("CompletedWithErrors");
        } else if (value.getResult() == 2) {
            result = TaskResultsTablePanel.i18n.translateString("Aborted");
        } else if (value.getResult() == 3) {
            result = TaskResultsTablePanel.i18n.translateString("Failed");
        }
        Object[] row = new Object[]{startDateString, endDateString, result};
        this.setRowValue(this._rows.size(), value);
        this._rows.add(this._rows.size(), row);
    }

    public void setRowValue(int rowindex, TaskRunResult value) {
        this._cache.put(rowindex, value);
    }

    public TaskRunResult getRowValue(int rowindex) {
        return this._cache.get(rowindex);
    }

    public void addColumn(String name) {
        this._columns.add(name);
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._rows.get(rowIndex)[columnIndex];
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void remove(int row) {
        this._rows.remove(row);
        this._cache.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void clear() {
        int rowCount = this._rows.size();
        this._rows.clear();
        this._cache.clear();
        this.fireTableRowsDeleted(0, rowCount - 1);
    }
}

