/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.subscribermanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.EntityManagerQueryJoinClass;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.subscribermanager.SubscriberEditorContainer;
import com.bwanms.model.Subscriber;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberManagerConfig
extends EntityManagerConfig {
    private static final Logger logger = Logger.getLogger(SubscriberManagerConfig.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberManagerConfig.class);
    private static String[] columnNames = new String[]{"SubscriberId", "Name", "AdminStatus", "DeploymentCount"};
    private static String[] columnAttribNames = new String[]{"SubscriberId", "Name", "synthetic1", "synthetic2"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public SubscriberManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), new EntityManagerRowComparator(3)));
        this.entityRowProvider = new SubscriberRowCreator(SubscriberManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("SubscriberId"), "subscriberId", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add(new ManagerFilterCriteria(){

            public ManagerFilterCriteriaView createView() {
                Vector<ComboItem> items = new Vector<ComboItem>();
                items.add(new ComboItem(1, i18n.translateString("Enabled")));
                items.add(new ComboItem(0, i18n.translateString("Disabled")));
                items.add(new ComboItem(2, i18n.translateString("Mixed")));
                items.add(new ComboItem(-1, i18n.translateString("Unknown")));
                return new EntityManagerFilterCriteriaView("SubscriberFilterByAdminStatus", i18n.translateString("AdminStatus"), null, "adminStatus", 2, 3, items, true, false){

                    public String getConditionToken(String alias) throws InvalidFilterValueException {
                        int selection = new Integer(this.getSelectedValues().get(0).toString());
                        switch (selection) {
                            case 1: {
                                return alias + ".subscriberEntries.size > 0 and " + alias + ".subscriberEntries.size = " + alias + ".subscriberEntriesEnabled.size";
                            }
                            case 0: {
                                return alias + ".subscriberEntries.size > 0 and " + alias + ".subscriberEntriesEnabled.size = 0";
                            }
                            case 2: {
                                return alias + ".subscriberEntries.size > 0 and " + alias + ".subscriberEntriesEnabled.size > 0 and " + alias + ".subscriberEntries.size > " + alias + ".subscriberEntriesEnabled.size";
                            }
                            case -1: {
                                return alias + ".subscriberEntries.size = 0";
                            }
                        }
                        return "";
                    }
                };
            }

            public String getName() {
                return "SubscriberFilterByAdminStatus";
            }
        });
        EntityManagerFilterCriteria deploymentCountCriteria = new EntityManagerFilterCriteria(i18n.translateString("DeploymentCount"), "subscriberEntries.size", 3, 2, null, true, false);
        deploymentCountCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            @Override
            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                if (!selectedValues.isEmpty()) {
                    try {
                        String value1 = (String)selectedValues.get(0);
                        String value2 = (String)selectedValues.get(1);
                        if (!value1.equals("") || !value2.equals("")) {
                            Integer.parseInt(value1);
                            Integer.parseInt(value2);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidFilterValueException(i18n.translateString("ValueMustBeANumber"));
                    }
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add(deploymentCountCriteria);
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new SubscriberManagerAction("New", 1));
        this.defaultAction = new SubscriberManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new SubscriberManagerAction("Delete", 1));
    }

    @Override
    protected String getBaseName() {
        return Subscriber.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(0);
        }
        this.defaultAction = new SubscriberManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    @Override
    public String getTitle() {
        return i18n.translateString("SubscriberManager");
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    @Override
    public String getHelpTopic() {
        return "managing_subscribers";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubscriberManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public SubscriberManagerAction(String name, int category) {
            this(name, category, null);
        }

        public SubscriberManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                EntityTypeSelectorContainer typeSelectorContainer = new EntityTypeSelectorContainer("Subscriber", (JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), i18n.translateString("Subscriber"));
                typeSelectorContainer.showDialog();
                Class selectedType = typeSelectorContainer.getSelectedEntityType();
                if (null != selectedType) {
                    try {
                        new SubscriberEditorContainer((Subscriber)selectedType.newInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if ("Open".equals(this.name) && selection.size() == 1) {
                Subscriber subscriber = (Subscriber)selection.get(0);
                try {
                    new SubscriberEditorContainer(subscriber);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && selection.size() > 0) {
                if (!MessageBox.Confirm.showResult(manager.getUI(), i18n.translateString("DeleteConfirmation"))) {
                    return;
                }
                final ServiceManagementService sms = ServiceRegistry.getServiceManagementService();
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteSubscribers");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (final Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Subscriber subscriber = (Subscriber)row;
                            this.monitor.updateProgress(progress, i18n.translateString("DeletingSubscriber", subscriber.getSubscriberId()));
                            try {
                                sms.deleteSubscriber(subscriber.getId());
                                if (manager instanceof EntityChangeListener) {
                                    UIEventThread.syncExec(new Runnable(){

                                        public void run() {
                                            ((EntityChangeListener)((Object)manager)).entityRemoved(row);
                                        }
                                    });
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", subscriber.getSubscriberId()));
                            }
                            catch (ServerValidationException sve) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingSubscriber", subscriber.getSubscriberId(), i18n.translateString(sve.getInvalidValues().get(0).getMessage())));
                            }
                            catch (Throwable t) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingSubscriber", subscriber.getSubscriberId(), t.getMessage()));
                                logger.error((Object)t, t);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("DeletingSubscriber", subscriber.getSubscriberId()));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureSubscribers", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureSubscribers", "delete")) {
                        return false;
                    }
                    return 0 < selectionSize;
                }
                if (this.name.equals("Select")) {
                    return 1 == selectionSize;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubscriberRowCreator
    extends EntityManagerRowProviderBase {
        SubscriberRowCreator(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            String adminStatusStr = null;
            try {
                Integer adminStatus = new Integer(ret.get(2));
                switch (adminStatus) {
                    case 1: {
                        adminStatusStr = "Enabled";
                        break;
                    }
                    case 0: {
                        adminStatusStr = "Disabled";
                        break;
                    }
                    case 2: {
                        adminStatusStr = "Mixed";
                        break;
                    }
                    case -1: {
                        adminStatusStr = "Unknown";
                    }
                }
            }
            catch (NumberFormatException nfe) {
                adminStatusStr = "Unknown";
            }
            ret.set(2, i18n.translateString(adminStatusStr));
            return ret;
        }

        @Override
        public List<EntityManagerQueryJoinClass> getEntityQueryJoinClasses() {
            List<EntityManagerQueryJoinClass> ret = super.getEntityQueryJoinClasses();
            if (null == ret) {
                ret = new ArrayList<EntityManagerQueryJoinClass>(1);
            }
            ret.add(new EntityManagerQueryJoinClass(Subscriber.class, new String[]{"subscriberEntries.size", "subscriberEntriesEnabled.size"}, new String[0], new String[0]));
            return ret;
        }

        @Override
        public EntityManagerRow createRow(Serializable entity) {
            Object[] obj = (Object[])entity;
            EntityManagerRow row = super.createRow((Serializable)obj[0]);
            int deploymentCount = (Integer)obj[1];
            int adminEnabledCount = (Integer)obj[2];
            int adminStatus = -1;
            if (0 != deploymentCount) {
                adminStatus = adminEnabledCount == deploymentCount ? 1 : (0 == adminEnabledCount ? 0 : 2);
            }
            row.setAttributeValue("synthetic1", (Serializable)Integer.valueOf(adminStatus));
            row.setAttributeValue("synthetic2", (Serializable)Integer.valueOf(deploymentCount));
            return row;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((Subscriber)entity).getId());
        }
    }
}

