/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.serviceprofilemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.EntityManagerSortByIdNoUI;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.serviceprofilemanager.ServiceProfileEditorContainer;
import com.bwanms.model.ServiceProfile;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProfileManagerConfig
extends EntityManagerConfig {
    private static Logger logger = Logger.getLogger(ServiceProfileManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ServiceProfileManagerConfig.class);
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static String[] columnNames = new String[]{"Name", "Type"};
    private static String[] columnAttribNames = new String[]{"Name", ""};
    private List<EntityManagerColumn> columns;
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private String baseName = ServiceProfile.class.getName();

    public ServiceProfileManagerConfig() {
        this.columns = new Vector<EntityManagerColumn>();
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.entityRowProvider = new ServiceProfileRowCreator(ServiceProfileManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        Vector<Object> items = new Vector<Object>();
        for (String serviceProfileType : EditorPluginUtil.getEntityTypes("ServiceProfile")) {
            items.add(new ComboItem(serviceProfileType, ddI18N.translateString(serviceProfileType)));
        }
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Type"), "CLASS", 2, 3, items, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new ServiceProfileManagerAction("New", 1));
        this.defaultAction = new ServiceProfileManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ServiceProfileManagerAction("Delete", 1));
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    @Override
    public SortView getSortView() {
        return new EntityManagerSortByIdNoUI();
    }

    @Override
    protected String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(0);
        }
        this.defaultAction = new ServiceProfileManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    public void removeTypeCriteria() {
        if (this.filterCriteria.size() >= 2) {
            this.filterCriteria.remove(1);
        }
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ServiceProfileManager");
    }

    @Override
    public String getHelpTopic() {
        return "ngnms.help.managing_service_profiles";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceProfileManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public ServiceProfileManagerAction(String name, int category) {
            this(name, category, null);
        }

        public ServiceProfileManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if (this.name.equals("New")) {
                EntityTypeSelectorContainer typeSelectorContainer = new EntityTypeSelectorContainer("ServiceProfile", (JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), i18n.translateString("ServiceProfile"));
                typeSelectorContainer.showDialog();
                Class selectedType = typeSelectorContainer.getSelectedEntityType();
                if (null != selectedType) {
                    try {
                        new ServiceProfileEditorContainer((ServiceProfile)selectedType.newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException ex) {
                        MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                    }
                }
            } else if (this.name.equals("Open")) {
                ServiceProfile profile = (ServiceProfile)selection.get(0);
                try {
                    new ServiceProfileEditorContainer(profile);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name)) {
                if (!FrameUtil.showConfirmation(manager.getUI())) {
                    return;
                }
                final ServiceManagementService sms = ServiceRegistry.getServiceManagementService();
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteServiceProfiles");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (final Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            ServiceProfile serviceProfile = (ServiceProfile)row;
                            this.monitor.updateProgress(progress, i18n.translateString("DeletingServiceProfile", serviceProfile.getName()));
                            try {
                                sms.deleteServiceProfile(serviceProfile.getId());
                                if (manager instanceof EntityChangeListener) {
                                    UIEventThread.syncExec(new Runnable(){

                                        public void run() {
                                            ((EntityChangeListener)((Object)manager)).entityRemoved(row);
                                        }
                                    });
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", serviceProfile.getName()));
                            }
                            catch (ServerValidationException sve) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingServiceProfile", serviceProfile.getName(), i18n.translateString(sve.getInvalidValues().get(0).getMessage())));
                            }
                            catch (Throwable t) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingServiceProfile", serviceProfile.getName(), t.getMessage()));
                                logger.error((Object)t, t);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("DeletingServiceProfile", serviceProfile.getName()));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New") && !Security.getSecurity().checkPermissions("Av:ConfigureSLA", "add")) {
                return false;
            }
            if (this.name.equals("Open")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureSLA", "delete")) {
                    return false;
                }
                return 0 < selectionSize;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ServiceProfileRowCreator
    extends EntityManagerRowProviderBase {
        public ServiceProfileRowCreator(List<String> attributes) {
            super(attributes);
        }

        @Override
        protected List<Serializable> readAttributeValues(Serializable entity) {
            List<Serializable> ret = super.readAttributeValues(entity);
            ret.set(1, (Serializable)((Object)entity.getClass().getName()));
            return ret;
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            ret.set(1, ddI18N.translateString(ret.get(1)));
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((ServiceProfile)entity).getId());
        }
    }
}

