/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.serviceprofilemanager;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.entity.EntityHandler;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.EntityHandlerPluginUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.awt.Window;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProfileEditorContainer
extends EntityEditorContainer<ServiceProfile> {
    private static final Logger logger = Logger.getLogger(ServiceProfileEditorContainer.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ServiceProfileEditorContainer.class);

    public ServiceProfileEditorContainer(ServiceProfile entity) throws ServiceException {
        this(entity, (Window)null, true);
    }

    public ServiceProfileEditorContainer(ServiceProfile entity, Window owner) throws ServiceException {
        this(entity, owner, true);
    }

    public ServiceProfileEditorContainer(ServiceProfile entity, Window owner, boolean returnImmediately) throws ServiceException {
        super(entity, owner, returnImmediately);
        if (entity.getId() > 0L) {
            this.form.getDefaultButton().setText(i18n.translateString("SaveAs"));
        }
    }

    @Override
    protected ServiceProfile loadEntity(ServiceProfile entity) throws ServiceException {
        if (null != entity && entity.getId() > 0L) {
            ServiceProfile profile = (ServiceProfile)ServiceRegistry.getEntityManagerService().get(entity.getClass(), entity.getId(), "Edit").getEntity();
            return profile;
        }
        return entity;
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((ServiceProfile)this.getEntity()).getId());
    }

    @Override
    protected EditorView<ServiceProfile> initView() {
        return EditorPluginUtil.getViewForClass(((ServiceProfile)this.getEntity()).getClass());
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ServiceProfileEditor");
    }

    @Override
    public void actionOKPerformed() {
        long id = ((ServiceProfile)this.getEntity()).getId();
        if (this.save() != null && id != ((ServiceProfile)this.getEntity()).getId()) {
            this.cleanup();
        }
    }

    @Override
    protected void saveEntity() throws ServerValidationException {
        if (((ServiceProfile)this.getEntity()).getId() != 0L && !MessageBox.Confirm.showResult(this.form, i18n.translateString("NewProfile"))) {
            return;
        }
        EntityHandler<?> handler = EntityHandlerPluginUtil.getHandlerForEntity(((ServiceProfile)this.getEntity()).getClass());
        if (handler == null) {
            throw new RuntimeException("Define EntityHandler for ServiceProfile " + ((ServiceProfile)this.getEntity()).getClass().getName());
        }
        this.setEntity(handler.handleSave(this.getEntity()));
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(ServiceProfile.class.getName());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((ServiceProfile)this.getEntity()).getName() : "";
    }
}

