/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.servicemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.IconEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.servicemanager.ServiceEditorContainer;
import com.bwanms.gui.servicemanager.ServiceManagerUtil;
import com.bwanms.model.Service;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerConfig
extends EntityManagerConfig {
    private static final Logger logger = Logger.getLogger(ServiceManagerConfig.class);
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ServiceManagerConfig.class);
    private String[] columnNames = new String[]{"Name", "Type", "AdminStatus", "OperStatus", "ServiceProfile", "CPE", "SubscriberID", "LastActiveInstance"};
    private String[] columnAttribNames = new String[]{"Name", "", "AdminStatus", "", "", "", "", ""};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public ServiceManagerConfig() {
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(this.columnNames[2], this.columnAttribNames[2], i18n.translateString(this.columnNames[2]), new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(this.columnNames[3], this.columnAttribNames[3], i18n.translateString(this.columnNames[3]), new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(this.columnNames[4], this.columnAttribNames[4], i18n.translateString(this.columnNames[4]), new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(this.columnNames[5], this.columnAttribNames[5], i18n.translateString(this.columnNames[5]), new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn(this.columnNames[6], this.columnAttribNames[6], i18n.translateString(this.columnNames[6]), new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn(this.columnNames[7], this.columnAttribNames[7], i18n.translateString(this.columnNames[7]), new EntityManagerRowComparator(7)));
        this.entityRowProvider = new ServiceRowCreator(ServiceManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        Vector<Object> items = new Vector<Object>();
        for (String serviceType : EditorPluginUtil.getEntityTypes("Service")) {
            items.add(new ComboItem(serviceType, ddI18N.translateString(serviceType)));
        }
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Type"), "CLASS", 2, 3, items, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("AdminStatus"), "adminStatus", 2, 3, ServiceManagerUtil.getAdminStatusComboTypes(), false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("OperStatus"), "state", 2, 3, ServiceManagerUtil.getOperStatusComboTypes(), false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("ServiceProfile"), "serviceProfile.name", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("CPE"), "subscriberUnitEUID", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("SubscriberID"), "subscriber.subscriberId", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new ServiceManagerAction("New", 1));
        this.defaultAction = new ServiceManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ServiceManagerAction("Delete", 1));
    }

    @Override
    protected String getBaseName() {
        return Service.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView(new IconEntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles()){

            protected Icon getIcon(Serializable entity) {
                return UIIconFactory.getIcon(entity, 2);
            }
        }, this.getColumns());
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ServiceManager");
    }

    @Override
    public ManagerFilterView getFilterView() {
        ManagerFilterView filterView = super.getFilterView();
        return filterView;
    }

    @Override
    public String getHelpTopic() {
        return "ngnms.help.managing_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceManagerAction
    extends ManagerAction {
        public ServiceManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                EntityTypeSelectorContainer typeSelectorContainer = new EntityTypeSelectorContainer("Service", (JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), i18n.translateString("Service"));
                typeSelectorContainer.showDialog();
                Class selectedType = typeSelectorContainer.getSelectedEntityType();
                if (null != selectedType) {
                    try {
                        new ServiceEditorContainer((Service)selectedType.newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException ex) {
                        MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                    }
                }
            } else if ("Open".equals(this.name) && 1 == selection.size()) {
                Service svc = (Service)selection.get(0);
                try {
                    new ServiceEditorContainer(svc);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name)) {
                if (!FrameUtil.showConfirmation(manager.getUI())) {
                    return;
                }
                final ServiceManagementService sms = ServiceRegistry.getServiceManagementService();
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteServices");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (final Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Service service = (Service)row;
                            this.monitor.updateProgress(progress, i18n.translateString("DeletingService", service.getName()));
                            try {
                                sms.deleteService(service.getId());
                                if (manager instanceof EntityChangeListener) {
                                    UIEventThread.syncExec(new Runnable(){

                                        public void run() {
                                            ((EntityChangeListener)((Object)manager)).entityRemoved(row);
                                        }
                                    });
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", service.getName()));
                            }
                            catch (ServerValidationException sve) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingService", service.getName(), i18n.translateString(sve.getInvalidValues().get(0).getMessage())));
                            }
                            catch (Throwable t) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingService", service.getName(), t.getMessage()));
                                logger.error((Object)t, t);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("DeletingService", service.getName()));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureServices", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureServices", "delete")) {
                        return false;
                    }
                    return 0 < selectionSize;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceRowCreator
    extends EntityManagerRowProviderBase {
        public ServiceRowCreator(List<String> attributes) {
            super(attributes);
        }

        @Override
        protected List<Serializable> readAttributeValues(Serializable entity) {
            List<Serializable> ret = super.readAttributeValues(entity);
            Service service = (Service)entity;
            ret.set(1, (Serializable)((Object)entity.getClass().getName()));
            ret.set(3, Integer.valueOf(service.getState()));
            if (null != service.getServiceProfile()) {
                ret.set(4, (Serializable)((Object)service.getServiceProfile().getName()));
            }
            ret.set(5, (Serializable)((Object)service.getSubscriberUnitEUID()));
            if (null != service.getSubscriber()) {
                ret.set(6, (Serializable)((Object)service.getSubscriber().getSubscriberId()));
            }
            if (null != service.getLastActiveInstance()) {
                ret.set(7, (Serializable)((Object)service.getLastActiveInstance().getEUID()));
            }
            return ret;
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            ret.set(1, ddI18N.translateString(ret.get(1)));
            ret.set(2, ServiceManagerUtil.getAdminStatusStr(ret.get(2)));
            ret.set(3, ServiceManagerUtil.getOperStatusStr(ret.get(3)));
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((Service)entity).getId());
        }
    }
}

