/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.model.Location;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TableCellSelectorComponent
extends JPanel {
    private SelectorView selectorView;
    private Location value;
    private JTextField txtName;
    private JButton btnClear;

    public TableCellSelectorComponent(Location value) {
        this.initComponents();
        this.setValue(value);
        this.txtName.setBorder(null);
        this.txtName.setBackground(Color.WHITE);
    }

    private void initComponents() {
        this.txtName = new JTextField();
        this.btnClear = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), new ColumnSpec(Sizes.bounded((Size)Sizes.DEFAULT, (Size)Sizes.dluX((int)15), (Size)Sizes.dluX((int)15)))}, RowSpec.decodeSpecs((String)"fill:15px")));
        this.txtName.setEditable(false);
        this.txtName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableCellSelectorComponent.this.txtNameMouseClicked(e);
            }
        });
        this.add((Component)this.txtName, cc.xy(1, 1));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/clear.gif")));
        this.btnClear.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TableCellSelectorComponent.this.btnClearMousePressed(e);
            }
        });
        this.add((Component)this.btnClear, cc.xy(2, 1));
    }

    private void txtNameMouseClicked(MouseEvent e) {
        this.selectorView = Selectors.getSelectorView(Location.class, "0");
        if (this.selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector(this, this.selectorView);
        List selections = this.selectorView.getSelection();
        if (!selections.isEmpty()) {
            this.setValue((Location)selections.get(0));
        }
    }

    private void btnClearMousePressed(MouseEvent e) {
        this.setValue(null);
    }

    public Location getValue() {
        return this.value;
    }

    public void setValue(Location value) {
        this.value = value;
        if (value != null) {
            this.txtName.setText(value.getName());
        } else {
            this.txtName.setText("");
        }
    }

    public JTextField getTxtName() {
        return this.txtName;
    }

    public JButton getBtnClear() {
        return this.btnClear;
    }

    public SelectorView getSelectorView() {
        return this.selectorView;
    }

    public void setSelectorView(SelectorView selectorView) {
        this.selectorView = selectorView;
    }
}

