/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.selectors.SelectorListViewValueDisplay;
import com.bwanms.ui.components.ListCellRenderer;
import com.bwanms.ui.components.ListItem;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectorListOneElementComponent
extends JPanel {
    private boolean nullable;
    private SelectorView selectorView;
    private Object value;
    private SelectorListViewValueDisplay display;
    public DefaultListModel listModel = new DefaultListModel();
    private JScrollPane scrollPane1;
    private JList listSelectedValues;
    private JButton btnSearch;
    private JButton btnClear;

    public SelectorListOneElementComponent() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.listSelectedValues.setCellRenderer(new ListCellRenderer());
        this.listSelectedValues.setModel(this.listModel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SelectorListOneElementComponent.this.btnClear.setEnabled(SelectorListOneElementComponent.this.value != null);
            }
        });
        this.display = new SelectorListViewValueDisplay(){

            @Override
            public List<ListItem> toDisplayString(Object value) {
                return (List)value;
            }
        };
        this.setNullable(false);
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.listSelectedValues = new JList();
        this.btnSearch = new JButton();
        this.btnClear = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("default:grow, 15dlu, 15dlu", "default:grow"));
        this.scrollPane1.setViewportView(this.listSelectedValues);
        this.add((Component)this.scrollPane1, cc.xywh(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/import.gif")));
        this.btnSearch.setToolTipText("TooltipSelect");
        this.btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorListOneElementComponent.this.btnSearchActionPerformed(e);
            }
        });
        this.add((Component)this.btnSearch, cc.xy(2, 1));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/clear.gif")));
        this.btnClear.setToolTipText("TooltipRemove");
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorListOneElementComponent.this.btnClearActionPerformed(e);
            }
        });
        this.add((Component)this.btnClear, cc.xy(3, 1));
    }

    private void btnSearchActionPerformed(ActionEvent e) {
        if (this.selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector(this, this.selectorView);
        List selection = this.selectorView.getSelection();
        if (!selection.isEmpty()) {
            this.setValue(selection);
        }
    }

    private void btnClearActionPerformed(ActionEvent e) {
        this.setValue(null);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.firePropertyChange("value", false, true);
    }

    public void setJListEnabled(boolean setTextAreaDisabled) {
        this.listSelectedValues.setEnabled(setTextAreaDisabled);
    }

    public SelectorView getSelectorView() {
        return this.selectorView;
    }

    public void setSelectorView(SelectorView selectorView) {
        this.selectorView = selectorView;
    }

    public void setDisplay(SelectorListViewValueDisplay display) {
        this.display = display;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        this.btnClear.setVisible(nullable);
    }

    public JButton getBtnClear() {
        return this.btnClear;
    }

    public JButton getBtnSearch() {
        return this.btnSearch;
    }

    public JList getListSelectedValues() {
        return this.listSelectedValues;
    }

    public void selectorEnabled(boolean enabled) {
        this.btnSearch.setEnabled(enabled);
        this.btnClear.setEnabled(this.value == null ? false : enabled);
    }

    public JScrollPane getScrollPane1() {
        return this.scrollPane1;
    }
}

