/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.selectors.SelectorListViewValueDisplay;
import com.bwanms.ui.components.ListCellRenderer;
import com.bwanms.ui.components.ListItem;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectorListComponent
extends JPanel {
    private static final long serialVersionUID = -4065463491984431655L;
    private boolean nullable;
    private SelectorView selectorView;
    private Object value;
    private SelectorListViewValueDisplay display;
    public DefaultListModel listModel = new DefaultListModel();
    private boolean isSelfContainedDialog = false;
    private JLabel lblName;
    private JButton btnSearch;
    private JButton btnClear;
    private JScrollPane scrollPane1;
    private JList listSelectedValues;

    public SelectorListComponent() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.btnClear.setEnabled(false);
        this.listSelectedValues.setCellRenderer(new ListCellRenderer());
        this.listSelectedValues.setModel(this.listModel);
        this.display = new SelectorListViewValueDisplay(){

            @Override
            public List<ListItem> toDisplayString(Object value) {
                return (List)value;
            }
        };
        this.setNullable(false);
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.btnSearch = new JButton();
        this.btnClear = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.listSelectedValues = new JList();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)15)), new ColumnSpec((Size)Sizes.dluX((int)15))}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.lblName.setText("Name");
        this.add((Component)this.lblName, cc.xy(1, 1));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/import.gif")));
        this.btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorListComponent.this.btnSearchActionPerformed(e);
            }
        });
        this.add((Component)this.btnSearch, cc.xy(3, 1));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/clear.gif")));
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorListComponent.this.btnClearActionPerformed(e);
            }
        });
        this.add((Component)this.btnClear, cc.xy(4, 1));
        this.listSelectedValues.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectorListComponent.this.listSelectedValuesValueChanged(e);
            }
        });
        this.scrollPane1.setViewportView(this.listSelectedValues);
        this.add((Component)this.scrollPane1, cc.xywh(1, 3, 4, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
    }

    private void btnSearchActionPerformed(ActionEvent e) {
        if (this.selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        if (this.isSelfContainedDialog) {
            SelectorUtil.displaySelfContainedSelectorDialog(this, this.selectorView);
        } else {
            SelectorUtil.displayModalSelector(this, this.selectorView);
        }
        List valueList = null;
        if (this.value != null) {
            valueList = new LinkedList((List)this.value);
            List selection = this.selectorView.getSelection();
            for (Object object : selection) {
                if (valueList.contains(object)) continue;
                valueList.add(object);
            }
        } else {
            valueList = this.selectorView.getSelection();
        }
        this.setValue(valueList);
    }

    private void btnClearActionPerformed(ActionEvent e) {
        int[] selectedIndices = this.listSelectedValues.getSelectedIndices();
        int counter = 0;
        try {
            LinkedList valueList = new LinkedList((List)this.value);
            for (int i = 0; i < selectedIndices.length; ++i) {
                valueList.remove(selectedIndices[i] - counter);
                ++counter;
            }
            this.setValue(valueList);
        }
        catch (ClassCastException cce) {
            this.setValue(null);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        Object newValue;
        Object oldvalue = this.value;
        this.value = newValue = value;
        this.firePropertyChange("value", oldvalue, newValue);
    }

    public void setJListEnabled(boolean setTextAreaDisabled) {
        this.listSelectedValues.setEnabled(setTextAreaDisabled);
    }

    public SelectorView getSelectorView() {
        return this.selectorView;
    }

    public void setSelectorView(SelectorView selectorView) {
        this.selectorView = selectorView;
    }

    public void setDisplay(SelectorListViewValueDisplay display) {
        this.display = display;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        this.btnClear.setVisible(nullable);
    }

    public JButton getBtnClear() {
        return this.btnClear;
    }

    public JButton getBtnSearch() {
        return this.btnSearch;
    }

    public JList getListSelectedValues() {
        return this.listSelectedValues;
    }

    public void selectorEnabled(boolean enabled) {
        this.btnSearch.setEnabled(enabled);
    }

    public JLabel getLblName() {
        return this.lblName;
    }

    private void listSelectedValuesValueChanged(ListSelectionEvent e) {
        if (this.listSelectedValues.getSelectedIndices().length >= 1) {
            this.btnClear.setEnabled(true);
        } else {
            this.btnClear.setEnabled(false);
        }
    }

    public JScrollPane getScrollPane1() {
        return this.scrollPane1;
    }

    public void setSelectorName(String name) {
        this.lblName.setText(name);
    }

    public void setSelfContainedDialog(boolean isSelfContainedDialog) {
        this.isSelfContainedDialog = isSelfContainedDialog;
    }
}

