/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.selectors.SelectorViewValueDisplay;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectorComponent
extends JPanel {
    private boolean nullable;
    private SelectorView selectorView;
    private Object value;
    private SelectorViewValueDisplay display;
    private boolean isMultipleSelection;
    private JTextField txtSelectedValues;
    private JButton btnSearch;
    private JButton btnClear;

    public SelectorComponent() {
        this.initComponents();
        this.postInitComponents();
    }

    public SelectorComponent(boolean isMultipleSelection) {
        this.isMultipleSelection = isMultipleSelection;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.display = new SelectorViewValueDisplay(){

            public String toDisplayString(Object value) {
                return value.toString();
            }
        };
        this.setNullable(false);
    }

    private void initComponents() {
        this.txtSelectedValues = new JTextField();
        this.btnSearch = new JButton();
        this.btnClear = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("max(default;50dlu):grow, 15dlu, 15dlu", "fill:default"));
        this.txtSelectedValues.setEditable(false);
        this.add((Component)this.txtSelectedValues, cc.xy(1, 1));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/import.gif")));
        this.btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorComponent.this.btnSearchActionPerformed(e);
            }
        });
        this.add((Component)this.btnSearch, cc.xy(2, 1));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/com/bwanms/gui/selectors/clear.gif")));
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorComponent.this.btnClearActionPerformed(e);
            }
        });
        this.add((Component)this.btnClear, cc.xy(3, 1));
    }

    private void btnSearchActionPerformed(ActionEvent e) {
        if (this.selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector(this, this.selectorView);
        List selection = this.selectorView.getSelection();
        if (!selection.isEmpty()) {
            this.setValue(!this.isMultipleSelection ? selection.get(0) : selection);
        }
    }

    private void btnClearActionPerformed(ActionEvent e) {
        this.setValue(null);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        if (value != null) {
            this.txtSelectedValues.setText(this.display.toDisplayString(value));
        } else {
            this.txtSelectedValues.setText("");
        }
        this.firePropertyChange("value", false, true);
    }

    public SelectorView getSelectorView() {
        return this.selectorView;
    }

    public void setSelectorView(SelectorView selectorView) {
        this.selectorView = selectorView;
    }

    public void setDisplay(SelectorViewValueDisplay display) {
        this.display = display;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        this.btnClear.setVisible(nullable);
    }

    public JButton getBtnClear() {
        return this.btnClear;
    }

    public JButton getBtnSearch() {
        return this.btnSearch;
    }

    public JTextField getTxtSelectedValues() {
        return this.txtSelectedValues;
    }
}

