/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.SelfContainedSelectorCallback;
import com.bwanms.gui.manager.generic.TypeManagerForm;
import com.bwanms.gui.manager.generic.TypeManagerView;
import com.bwanms.gui.selectors.AbstractSelfContainedSelectorView;
import com.bwanms.gui.selectors.GenericSelfContainedSelectorView;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.Assembly;
import com.bwanms.ui.components.ComboItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkElementSelectorView
extends AbstractSelfContainedSelectorView<Equipment>
implements SelectorView<Equipment> {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(TypeManagerView.class);
    static final Internationalizer ddI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
    protected TypeManagerForm form;
    private String title;
    private List<String> entityTypes = new Vector<String>();
    private Map<String, SelectorView> selectorViewsByEntityType = new HashMap<String, SelectorView>();
    private String selectedEntityType;
    private SelectorView currentSelector = null;

    public NetworkElementSelectorView(List<String> selectorList) {
        this.entityTypes = selectorList;
        this.initEntities();
    }

    @Override
    public List<Equipment> getSelection() {
        if (this.currentSelector != null) {
            return this.currentSelector.getSelection();
        }
        return null;
    }

    @Override
    public List<Assembly<Equipment>> getSelectionData() {
        if (this.currentSelector != null) {
            return this.currentSelector.getSelectionData();
        }
        return null;
    }

    @Override
    public void clearSelection() {
        if (this.currentSelector != null) {
            this.currentSelector.clearSelection();
        }
    }

    public void initEntities() {
        for (String equipmentName : this.entityTypes) {
            SelectorView<?> selectorView = null;
            try {
                Class<?> clazz = Class.forName(equipmentName);
                selectorView = Selectors.getSelectorView(clazz, clazz.toString());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (selectorView == null) continue;
            GenericSelfContainedSelectorView abstractView = (GenericSelfContainedSelectorView)selectorView;
            abstractView.setCallback(new SelfContainedSelectorCallback(){

                public void entitiesSelected(List selection) {
                    ((JDialog)NetworkElementSelectorView.this.form.getTopLevelAncestor()).setVisible(false);
                }
            });
            this.selectorViewsByEntityType.put(equipmentName, selectorView);
        }
    }

    @Override
    public JComponent getUI() {
        if (null == this.form) {
            ComboItem item;
            this.form = new TypeManagerForm();
            i18n.getSwingInternationalizer().translateComponent(this.form);
            for (String entityType : this.entityTypes) {
                this.form.getCmbEntityType().addItem(new ComboItem(entityType, ddI18n.translateString(entityType)));
            }
            this.form.getCmbEntityType().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NetworkElementSelectorView.this.entityTypeChanged(false);
                }
            });
            if (null != this.selectedEntityType && null != (item = ComboItem.findItemByValue(this.form.getCmbEntityType(), this.selectedEntityType))) {
                this.form.getCmbEntityType().setSelectedItem(item);
                this.entityTypeChanged(true);
            }
            this.entityTypeChanged(false);
        }
        return this.form;
    }

    private void entityTypeChanged(boolean force) {
        String entityType = (String)((ComboItem)this.form.getCmbEntityType().getSelectedItem()).getValue();
        if (force || null == this.selectedEntityType || !entityType.equals(this.selectedEntityType)) {
            this.currentSelector = this.selectorViewsByEntityType.get(entityType);
            this.form.setEntityManagerPanel(this.currentSelector.getUI());
            this.selectedEntityType = entityType;
        }
    }

    @Override
    public boolean close() {
        for (SelectorView view : this.selectorViewsByEntityType.values()) {
            if (view.close()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cleanup() {
        for (SelectorView view : this.selectorViewsByEntityType.values()) {
            view.cleanup();
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

