/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.selectors;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumTreeSelectorPanel
extends JPanel {
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    public DefaultTreeModel model;
    private JScrollPane scrollPane1;
    private JTree tree;

    public EnumTreeSelectorPanel(String rootName) {
        this.initComponents();
        this.postInitComponents(rootName);
    }

    private void postInitComponents(String rootName) {
        this.model = new DefaultTreeModel(new DefaultMutableTreeNode(rootName){});
        this.tree.setModel(this.model);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            public String getText() {
                return faulti18n.translateString(super.getText());
            }
        });
        this.tree.setShowsRootHandles(true);
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.tree = new JTree();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;170dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                EnumTreeSelectorPanel.this.treeMouseReleased(e);
            }
        });
        this.scrollPane1.setViewportView(this.tree);
        this.add((Component)this.scrollPane1, cc.xywh(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
    }

    public JTree getTree() {
        return this.tree;
    }

    public void addItems(Object primaryNode, Enum<?>[] nodeItems) {
        MutableTreeNode root = (MutableTreeNode)this.model.getRoot();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(primaryNode);
        this.model.insertNodeInto(rootNode, root, root.getChildCount());
        for (Enum<?> obj : nodeItems) {
            if ("unexpectedValue".equals(obj.name())) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
            this.model.insertNodeInto(node, rootNode, rootNode.getChildCount());
        }
    }

    public List<Enum<?>> getSelectedValues() {
        ArrayList selectedEnums = new ArrayList();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.getChildCount() != 0) continue;
                Object value = node.getUserObject();
                if (node.getUserObject() == null || !(value instanceof Enum)) continue;
                selectedEnums.add((Enum)node.getUserObject());
            }
        }
        return selectedEnums;
    }

    private void treeMouseReleased(MouseEvent e) {
        if (!this.getSelectedValues().isEmpty()) {
            SelectorUtil.doubleClickExit(e.getClickCount(), this);
        }
    }
}

