/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.scheduler;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.scheduler.ScheduleView;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.model.Task;
import com.bwanms.model.TaskObserver;
import com.bwanms.model.TaskSchedule;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.ServerValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduleEditorContainer
extends EntityEditorContainer<TaskSchedule>
implements TaskObserver {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskScheduleEditorContainer.class);

    public TaskScheduleEditorContainer(TaskSchedule entity) throws ServiceException {
        super(entity);
        TaskManagerMediator.addTaskScheduleEditor(this);
    }

    public void requestFocus() {
        this.getFrame().setState(0);
        this.getFrame().requestFocus();
    }

    @Override
    protected void saveEntity() throws ServerValidationException {
        ((TaskSchedule)this.getEntity()).getTask().setSchedule((TaskSchedule)this.getEntity());
        ServiceRegistry.getTaskManagerService().updateTask(((TaskSchedule)this.getEntity()).getTask(), 0);
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskSchedule", "TaskManager", ((TaskSchedule)this.getEntity()).getTask().getName(), ((TaskSchedule)this.getEntity()).getTask().getClass().getName());
    }

    public Long getTaskId() {
        return ((TaskSchedule)this.getEntity()).getTask().getId();
    }

    @Override
    public String getEntityId() {
        if (((TaskSchedule)this.getEntity()).getId() == 0L) {
            return String.valueOf(((TaskSchedule)this.getEntity()).getTask().getId());
        }
        return String.valueOf(((TaskSchedule)this.getEntity()).getId());
    }

    @Override
    protected EditorView<TaskSchedule> initView() {
        return new ScheduleView();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ScheduleEditor");
    }

    @Override
    public void cleanup() {
        TaskManagerMediator.removeTaskScheduleEditor(this);
        super.cleanup();
    }

    @Override
    public void taskStateChanged(Task task) {
        if (task.getState() != 0) {
            this.form.getDefaultButton().setEnabled(false);
        } else {
            this.form.getDefaultButton().setEnabled(true);
        }
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(TaskSchedule.class.getName());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null && ((TaskSchedule)this.getEntity()).getTask() != null ? ((TaskSchedule)this.getEntity()).getTask().getName() : "";
    }
}

