/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.scheduler;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.scheduler.EndPart;
import com.bwanms.gui.scheduler.RecurrencePart;
import com.bwanms.gui.scheduler.SchedulePanel;
import com.bwanms.model.ScheduleRecurrence;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.util.FormUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleView
extends AbstractBindedEditorView<TaskSchedule> {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(ScheduleView.class);
    private SchedulePanel panel = new SchedulePanel();

    @Override
    public void fillUI(TaskSchedule entity) {
        if (entity.getScheduleStart() != null) {
            this.panel.getStartPart1().getRadioAt().setSelected(true);
            this.panel.getStartPart1().getDateChooser1().setDate(entity.getScheduleStart());
        }
        if (entity.getRecurrence() != null) {
            ScheduleRecurrence recurrence = entity.getRecurrence();
            switch (recurrence.getType()) {
                case 1: {
                    this.panel.getRecurrencePart1().getRadioMinutely().setSelected(true);
                    break;
                }
                case 2: {
                    this.panel.getRecurrencePart1().getRadioHourly().setSelected(true);
                    break;
                }
                case 3: {
                    this.panel.getRecurrencePart1().getRadioDaily().setSelected(true);
                    break;
                }
                case 4: {
                    this.panel.getRecurrencePart1().getRadioWeekly().setSelected(true);
                    break;
                }
                case 5: {
                    this.panel.getRecurrencePart1().getRadioMonthly().setSelected(true);
                }
            }
            this.panel.getRecurrencePart1().getController().checkSelected();
            this.panel.getRecurrencePart1().setInnerPanelValues(recurrence.getValues());
            if (recurrence.getType() != 0) {
                EndPart endPart = this.panel.getRecurrencePart1().getEndPart();
                switch (recurrence.getEndType()) {
                    case 1: {
                        endPart.getRadioAfter().setSelected(true);
                        endPart.getSpnrOcurrences().setValue(recurrence.getEndOcurrences());
                        break;
                    }
                    case 2: {
                        endPart.getRadioAt().setSelected(true);
                        endPart.getDateChooser1().setDate(recurrence.getEndDate());
                    }
                }
            }
            if (PerformanceCollectionGenericTask.class.isAssignableFrom(entity.getTask().getClass())) {
                Component comp;
                RecurrencePart recurrencePanel = this.panel.getRecurrencePart1();
                recurrencePanel.getRadioNone().setEnabled(false);
                recurrencePanel.getRadioMinutely().setEnabled(false);
                recurrencePanel.getRadioHourly().setEnabled(false);
                recurrencePanel.getRadioDaily().setEnabled(false);
                recurrencePanel.getRadioWeekly().setEnabled(false);
                recurrencePanel.getRadioMonthly().setEnabled(false);
                JPanel innerPanel = recurrencePanel.getInnerPanel();
                innerPanel.setEnabled(false);
                if (innerPanel.getComponentCount() > 0 && (comp = innerPanel.getComponent(0)) instanceof JPanel) {
                    FormUtil.setEnabled((Container)comp, false);
                }
            }
        } else {
            this.panel.getRecurrencePart1().getController().checkSelected();
        }
    }

    @Override
    public List<InvalidValue> configureEntity(TaskSchedule entity) {
        Date date;
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        Date startDate = null;
        startDate = this.panel.getStartPart1().getRadioAt().isSelected() ? this.panel.getStartPart1().getDateChooser1().getDate() : new Date();
        entity.setScheduleStart(startDate);
        ScheduleRecurrence recurrence = entity.getRecurrence();
        if (recurrence == null) {
            recurrence = new ScheduleRecurrence();
            entity.setRecurrence(recurrence);
        }
        if (!startDate.after(date = new Date(System.currentTimeMillis() - 1L))) {
            invalidValues.add(new InvalidValue(i18n.translateString("StartAfterCurrent"), TaskSchedule.class, "", (Object)"", (Object)entity));
        }
        if (this.panel.getRecurrencePart1().getRadioNone().isSelected()) {
            recurrence.resetParams();
            recurrence.setType(0);
            recurrence.setEndValues(0, null, null);
        } else {
            recurrence.setValues(this.panel.getRecurrencePart1().getInnerPanelValues());
            if (this.panel.getRecurrencePart1().getEndPart().getRadioNever().isSelected()) {
                recurrence.setEndValues(0, null, null);
            }
            if (this.panel.getRecurrencePart1().getEndPart().getRadioAfter().isSelected()) {
                recurrence.setEndValues(1, null, (Integer)this.panel.getRecurrencePart1().getEndPart().getSpnrOcurrences().getValue());
            }
            if (this.panel.getRecurrencePart1().getEndPart().getRadioAt().isSelected()) {
                Date endDate = this.panel.getRecurrencePart1().getEndPart().getDateChooser1().getDate();
                recurrence.setEndValues(2, endDate, null);
                if (!startDate.before(endDate)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("StartAfterEnd"), TaskSchedule.class, "", (Object)"", (Object)entity));
                } else if (PerformanceCollectionGenericTask.class.isAssignableFrom(entity.getTask().getClass())) {
                    int ocurrences = this.translateToOcurrences(startDate, endDate, 900000L);
                    recurrence.setEndValues(1, null, ocurrences);
                }
            }
        }
        invalidValues.addAll(super.configureEntity(entity));
        return invalidValues;
    }

    int translateToOcurrences(Date startDate, Date endDate, long interval) {
        long diff = endDate.getTime() - startDate.getTime();
        return (int)Math.floor(diff / interval);
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("Schedule");
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.help.taskscheduleeditor";
    }
}

