/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.pmcollectionmanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.model.file.FileUtil;
import com.bwanms.model.file.PerformanceCollectionFile;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(PMCollectionManagerConfig.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(PMCollectionManagerConfig.class);
    private static String[] columnNames = new String[]{"TaskName", "EntityName", "CounterCategory", "PollingInterval", "Date", "Description"};
    private static String[] columnAttribNames = new String[]{"taskName", "entityName", "counterCategory", "pollingInterval", "date", "description"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public PMCollectionManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.entityRowProvider = new PMCollectionManagerRowProvider(PMCollectionManagerConfig.getColumnAttributeNames(this.columns));
        this.setupFilterCriteria();
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new PMCollectionManagerAction("Export", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new PMCollectionManagerAction("Delete", 1));
    }

    private void setupFilterCriteria() {
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("TaskName"), "taskName", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("EntityName"), "entityName", 1, 1, null, false));
        Vector<Object> counterCategories = new Vector<Object>(3);
        counterCategories.add(new ComboItem(1, i18n.translateString("CategoryCapacity")));
        counterCategories.add(new ComboItem(2, i18n.translateString("CategoryTraffic")));
        counterCategories.add(new ComboItem(3, i18n.translateString("CategoryRadio")));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("CounterCategory"), "counterCategory", 2, 3, counterCategories, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("PollingInterval"), "pollingInterval", 1, 1, null, false));
        EntityManagerFilterCriteria dateCriteria = new EntityManagerFilterCriteria(i18n.translateString("Date"), "timestamp", 4, 7, null, false);
        dateCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            @Override
            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            SimpleDateFormat dateFrom = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            Date date = dateFrom.parse(val);
                            selectedValues.set(i, date.getTime());
                            if (i != 1 || ((Long)selectedValues.get(i - 1)).compareTo((Long)selectedValues.get(i)) <= 0) continue;
                            throw new InvalidFilterValueException(val);
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add(dateCriteria);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Description"), "description", 1, 1, null, false));
    }

    @Override
    protected String getBaseName() {
        return PerformanceCollectionFile.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PMCollectionManager");
    }

    @Override
    public String getHelpTopic() {
        return "pmcollection_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PMCollectionManagerRowProvider
    extends DefaultRowCreator {
        private static final long serialVersionUID = 6125739920856279280L;

        public PMCollectionManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((PerformanceCollectionFile)entity).getId());
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            String counterCateg = null;
            switch ((Integer)entityRow.getAttributeValue("counterCategory")) {
                case 1: {
                    counterCateg = "CategoryCapacity";
                    break;
                }
                case 2: {
                    counterCateg = "CategoryTraffic";
                    break;
                }
                case 3: {
                    counterCateg = "CategoryRadio";
                }
            }
            ret.set(2, counterCateg != null ? i18n.translateString(counterCateg) : "");
            Date date = (Date)entityRow.getAttributeValue("date");
            ret.set(4, DateFormatter.formatSimple(date));
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PMCollectionManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;
        private String exportPath;

        public PMCollectionManagerAction(String name, int category) {
            this(name, category, null);
        }

        public PMCollectionManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selections = manager.getSelection();
            if ("Export".equals(this.name) && !selections.isEmpty()) {
                try {
                    String currentExportPath = this.selectExportPath();
                    if (null == currentExportPath) {
                        return;
                    }
                    this.exportPath = currentExportPath;
                }
                catch (IOException e) {
                    log.error((Object)i18n.translateString("ExportPathError"), (Throwable)e);
                }
                AbstractLongOperation exportOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("ExportTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            boolean success = false;
                            PerformanceCollectionFile file = (PerformanceCollectionFile)row;
                            String message = i18n.translateString("ExportingFile", file.getTaskName(), DateFormatter.formatSimple(file.getDate()));
                            this.monitor.updateProgress(progress, message);
                            try {
                                PMCollectionManagerAction.this.exportFile(file);
                                success = true;
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", file.getTaskName(), DateFormatter.formatSimple(file.getDate())));
                            }
                            catch (IOException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", file.getTaskName(), DateFormatter.formatSimple(file.getDate())));
                            }
                            if (success) {
                                this.monitor.logMessage(i18n.translateString("SuccesfullyExported", file.getTaskName(), DateFormatter.formatSimple(file.getDate())));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), exportOperation);
            } else if ("Delete".equals(this.name) && !selections.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), i18n.translateString("DeleteConfirmation"), i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            PerformanceCollectionFile backup = (PerformanceCollectionFile)row;
                            String formattedDate = DateFormatter.formatSimple(backup.getDate());
                            String message = i18n.translateString("DeletingBackup", backup.getTaskName(), formattedDate);
                            this.monitor.updateProgress(progress, message);
                            try {
                                ServiceRegistry.getEntityManagerService().delete(backup);
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", backup.getTaskName(), formattedDate));
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("DeletingError", backup.getTaskName(), formattedDate));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            }
        }

        private String selectExportPath() throws IOException {
            String selectedExportPath = null;
            JFrame frame = FrameUtil.createFrame();
            JDirectoryChooser dirChooser = new JDirectoryChooser();
            String openingPath = this.exportPath;
            if (null == openingPath) {
                openingPath = ".";
            }
            dirChooser.setCurrentDirectory(new File(openingPath));
            dirChooser.setDialogTitle(i18n.translateString("ChooseDirectoryTitle"));
            dirChooser.setMultiSelectionEnabled(false);
            dirChooser.setDialogType(1);
            dirChooser.setApproveButtonText(i18n.translateString("Select"));
            if (dirChooser.showSaveDialog((Component)frame) == 0) {
                selectedExportPath = dirChooser.getSelectedFile().getCanonicalPath();
            }
            return selectedExportPath;
        }

        private void exportFile(PerformanceCollectionFile pmCollectionFile) throws ServiceException, IOException {
            String fullPathFileName = this.exportPath + File.separator + FileUtil.escapeForFilesystem(pmCollectionFile.getFileName());
            File file = new File(fullPathFileName);
            FileOutputStream pw = new FileOutputStream(file);
            pw.write(FileUtil.getFileBytes(pmCollectionFile, true));
            pw.flush();
            pw.close();
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Export")) {
                return selectionSize > 0;
            }
            if (this.name.equals("Delete")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                    return false;
                }
                return selectionSize > 0;
            }
            return true;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }
    }
}

