/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.TypeManagerForm;
import com.bwanms.model.Settings;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManagerView
implements View {
    private static Logger logger = Logger.getLogger(TypeManagerView.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(TypeManagerView.class);
    static final Internationalizer ddI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private String managerName;
    protected TypeManagerForm form;
    private String title;
    private List<String> entityTypes = new Vector<String>();
    private Map<String, Class<? extends EntityManagerConfig>> entityConfigClassesByEntityType = new HashMap<String, Class<? extends EntityManagerConfig>>();
    private Map<String, ManagerView> managerViewsByEntityType = new HashMap<String, ManagerView>();
    private String selectedEntityType;

    public TypeManagerView(String managerName) {
        this.managerName = managerName;
        this.initEntities();
        this.loadSettings();
    }

    public void initEntities() {
        try {
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.managerTypes");
            if (null != extensionPoint) {
                TreeMap<Integer, String> entityTypesMap = new TreeMap<Integer, String>();
                for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                    String crtManagerName = element.getAttribute("managerName");
                    if (!this.managerName.equals(crtManagerName)) continue;
                    String entityType = element.getAttribute("entityType");
                    String entityConfigClass = element.getAttribute("entityConfigClass");
                    Integer location = Integer.parseInt(element.getAttribute("location"));
                    Class<?> clazz = Class.forName(entityConfigClass);
                    entityTypesMap.put(location, entityType);
                    this.entityConfigClassesByEntityType.put(entityType, clazz);
                }
                for (Integer location : entityTypesMap.keySet()) {
                    this.entityTypes.add((String)entityTypesMap.get(location));
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Configuration Error!", (Throwable)e);
            return;
        }
    }

    @Override
    public JComponent getUI() {
        if (null == this.form) {
            ComboItem item;
            this.form = new TypeManagerForm();
            i18n.getSwingInternationalizer().translateComponent(this.form);
            for (String entityType : this.entityTypes) {
                this.form.getCmbEntityType().addItem(new ComboItem(entityType, ddI18n.translateString(entityType)));
            }
            this.form.getCmbEntityType().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeManagerView.this.entityTypeChanged(false);
                }
            });
            if (null != this.selectedEntityType && null != (item = ComboItem.findItemByValue(this.form.getCmbEntityType(), this.selectedEntityType))) {
                this.form.getCmbEntityType().setSelectedItem(item);
                this.entityTypeChanged(true);
            }
            this.entityTypeChanged(false);
        }
        return this.form;
    }

    private void entityTypeChanged(boolean force) {
        String entityType = (String)((ComboItem)this.form.getCmbEntityType().getSelectedItem()).getValue();
        if (force || null == this.selectedEntityType || !entityType.equals(this.selectedEntityType)) {
            ManagerView managerView = this.managerViewsByEntityType.get(entityType);
            if (null == managerView) {
                try {
                    managerView = new EntityManagerView(this.entityConfigClassesByEntityType.get(entityType).newInstance());
                    this.managerViewsByEntityType.put(entityType, managerView);
                }
                catch (InstantiationException e) {
                    logger.error((Object)"Plugin Error!", (Throwable)e);
                    return;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)"Plugin Error!", (Throwable)e);
                    return;
                }
            }
            this.form.setEntityManagerPanel(managerView.getUI());
            this.selectedEntityType = entityType;
        }
    }

    private void loadSettings() {
        try {
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            this.selectedEntityType = settings.getProperty("SelectedManagerType:" + this.managerName, null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void saveSettings() {
        try {
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            settings.setProperty("SelectedManagerType:" + this.managerName, this.selectedEntityType);
            ServiceRegistry.getSettingsService().updateSettings(settings);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public boolean close() {
        for (ManagerView view : this.managerViewsByEntityType.values()) {
            if (view.close()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cleanup() {
        for (ManagerView view : this.managerViewsByEntityType.values()) {
            view.cleanup();
        }
        this.saveSettings();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, ManagerView> getManagerViewsByEntityType() {
        return this.managerViewsByEntityType;
    }
}

