/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.manager.generic.EntityQueryStrategyBase;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;

public class SinglePageQueryStrategy
extends EntityQueryStrategyBase {
    private static Logger logger = Logger.getLogger(SinglePageQueryStrategy.class);
    protected String queryString;
    protected String countQueryString;
    protected int pageSize;

    public EntityQueryResults performQuery(EntityQueryFilter filter, EntityQuerySort sort, int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.countQueryString = this.queryString = filter.getFilterQueryString();
        if (null != sort) {
            this.queryString = this.queryString + " " + sort.getSortQueryString();
        }
        this.rowCreator = filter.getEntityRowCreator();
        return this.getPage(pageNumber);
    }

    public EntityQueryResults getPage(int pageNumber) {
        logger.debug((Object)("---- getPage: " + pageNumber + "   queryString: [" + this.queryString + "]   pageSize: " + this.pageSize));
        try {
            long time1 = System.currentTimeMillis();
            Query pageQuery = Datastore.session().createQuery(this.queryString);
            if (this.pageSize > 0) {
                pageQuery.setFirstResult(pageNumber * this.pageSize);
                pageQuery.setMaxResults(this.pageSize);
            }
            List ret = pageQuery.list();
            long time2 = System.currentTimeMillis();
            this.countQueryString = "select count(*) " + this.countQueryString.substring(this.countQueryString.indexOf("from"));
            Query countQuery = Datastore.session().createQuery(this.countQueryString);
            int resultSize = 0;
            Integer uniqueResult = (Integer)countQuery.uniqueResult();
            if (uniqueResult != null) {
                resultSize = uniqueResult;
            }
            long time3 = System.currentTimeMillis();
            logger.debug((Object)("---- QUERY - page: " + (time2 - time1) + " millis,  count: " + (time3 - time2) + " millis,  page+count: " + (time3 - time1) + " millis."));
            long time = System.currentTimeMillis();
            ArrayList<EntityManagerRow> page = new ArrayList<EntityManagerRow>(this.pageSize);
            for (Serializable obj : ret) {
                page.add(this.createRowFromEntityOrProxy(obj));
            }
            logger.debug((Object)("---- results size: " + resultSize + ",  page size: " + page.size() + ",  page created in: " + (System.currentTimeMillis() - time) + " millis."));
            return new EntityQueryResults(resultSize, this.pageSize, pageNumber, page);
        }
        catch (HibernateException he) {
            logger.error((Object)he.getMessage(), (Throwable)he);
            return null;
        }
    }

    public void closeQuery() {
    }
}

